@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The JSON object that contains the properties to determine origin health using real requests/responses.
 * @property httpErrorRanges The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
 * @property responseBasedDetectedErrorTypes Type of response errors for real user requests for which origin will be deemed unhealthy
 * @property responseBasedFailoverThresholdPercentage The percentage of failed requests in the sample where failover should trigger.
 */
public data class ResponseBasedOriginErrorDetectionParametersResponse(
    public val httpErrorRanges: List<HttpErrorRangeParametersResponse>? = null,
    public val responseBasedDetectedErrorTypes: String? = null,
    public val responseBasedFailoverThresholdPercentage: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.ResponseBasedOriginErrorDetectionParametersResponse): ResponseBasedOriginErrorDetectionParametersResponse =
            ResponseBasedOriginErrorDetectionParametersResponse(
                httpErrorRanges = javaType.httpErrorRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cdn.kotlin.outputs.HttpErrorRangeParametersResponse.Companion.toKotlin(args0)
                    })
                }),
                responseBasedDetectedErrorTypes = javaType.responseBasedDetectedErrorTypes().map({ args0 ->
                    args0
                }).orElse(null),
                responseBasedFailoverThresholdPercentage = javaType.responseBasedFailoverThresholdPercentage().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
