@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the route configuration override action.
 * @property cacheConfiguration The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
 * @property originGroupOverride A reference to the origin group override configuration. Leave empty to use the default origin group on route.
 * @property typeName
 */
public data class RouteConfigurationOverrideActionParametersResponse(
    public val cacheConfiguration: CacheConfigurationResponse? = null,
    public val originGroupOverride: OriginGroupOverrideResponse? = null,
    public val typeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.RouteConfigurationOverrideActionParametersResponse): RouteConfigurationOverrideActionParametersResponse =
            RouteConfigurationOverrideActionParametersResponse(
                cacheConfiguration = javaType.cacheConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cdn.kotlin.outputs.CacheConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                originGroupOverride = javaType.originGroupOverride().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cdn.kotlin.outputs.OriginGroupOverrideResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                typeName = javaType.typeName(),
            )
    }
}
