@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * settings for security policy patterns to match
 * @property domains List of domains.
 * @property patternsToMatch List of paths
 */
public data class SecurityPolicyWebApplicationFirewallAssociationResponse(
    public val domains: List<ActivatedResourceReferenceResponse>? = null,
    public val patternsToMatch: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.SecurityPolicyWebApplicationFirewallAssociationResponse): SecurityPolicyWebApplicationFirewallAssociationResponse =
            SecurityPolicyWebApplicationFirewallAssociationResponse(
                domains = javaType.domains().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cdn.kotlin.outputs.ActivatedResourceReferenceResponse.Companion.toKotlin(args0)
                    })
                }),
                patternsToMatch = javaType.patternsToMatch().map({ args0 -> args0 }),
            )
    }
}
