@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the parameters for the Url Signing action.
 * @property algorithm Algorithm to use for URL signing
 * @property parameterNameOverride Defines which query string parameters in the url to be considered for expires, key id etc.
 * @property typeName
 */
public data class UrlSigningActionParametersResponse(
    public val algorithm: String? = null,
    public val parameterNameOverride: List<UrlSigningParamIdentifierResponse>? = null,
    public val typeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlSigningActionParametersResponse): UrlSigningActionParametersResponse = UrlSigningActionParametersResponse(
            algorithm = javaType.algorithm().map({ args0 -> args0 }).orElse(null),
            parameterNameOverride = javaType.parameterNameOverride().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.UrlSigningParamIdentifierResponse.Companion.toKotlin(args0)
                })
            }),
            typeName = javaType.typeName(),
        )
    }
}
