@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the url signing action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'UrlSigning'.
 * @property parameters Defines the parameters for the action.
 */
public data class UrlSigningActionResponse(
    public val name: String,
    public val parameters: UrlSigningActionParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlSigningActionResponse): UrlSigningActionResponse = UrlSigningActionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.UrlSigningActionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
