@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Url signing key parameters
 * @property keyId Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
 * @property secretSource Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
 * @property secretVersion Version of the secret to be used
 * @property type The type of the secret resource.
 * Expected value is 'UrlSigningKey'.
 */
public data class UrlSigningKeyParametersResponse(
    public val keyId: String,
    public val secretSource: ResourceReferenceResponse,
    public val secretVersion: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlSigningKeyParametersResponse): UrlSigningKeyParametersResponse = UrlSigningKeyParametersResponse(
            keyId = javaType.keyId(),
            secretSource = javaType.secretSource().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
            }),
            secretVersion = javaType.secretVersion().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
