@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Url signing key
 * @property keyId Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
 * @property keySourceParameters Defines the parameters for using customer key vault for Url Signing Key.
 */
public data class UrlSigningKeyResponse(
    public val keyId: String,
    public val keySourceParameters: KeyVaultSigningKeyParametersResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlSigningKeyResponse): UrlSigningKeyResponse = UrlSigningKeyResponse(
            keyId = javaType.keyId(),
            keySourceParameters = javaType.keySourceParameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.KeyVaultSigningKeyParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
