@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines how to identify a parameter for a specific purpose e.g. expires
 * @property paramIndicator Indicates the purpose of the parameter
 * @property paramName Parameter name
 */
public data class UrlSigningParamIdentifierResponse(
    public val paramIndicator: String,
    public val paramName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.UrlSigningParamIdentifierResponse): UrlSigningParamIdentifierResponse = UrlSigningParamIdentifierResponse(
            paramIndicator = javaType.paramIndicator(),
            paramName = javaType.paramName(),
        )
    }
}
