@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin

import com.pulumi.azurenative.certificateregistration.kotlin.outputs.AppServiceCertificateResponse
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateDetailsResponse
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateOrderContactResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.AppServiceCertificateResponse.Companion.toKotlin as appServiceCertificateResponseToKotlin
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateDetailsResponse.Companion.toKotlin as certificateDetailsResponseToKotlin
import com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateOrderContactResponse.Companion.toKotlin as certificateOrderContactResponseToKotlin

/**
 * Builder for [AppServiceCertificateOrder].
 */
@PulumiTagMarker
public class AppServiceCertificateOrderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppServiceCertificateOrderArgs = AppServiceCertificateOrderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppServiceCertificateOrderArgsBuilder.() -> Unit) {
        val builder = AppServiceCertificateOrderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppServiceCertificateOrder {
        val builtJavaResource =
            com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrder(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppServiceCertificateOrder(builtJavaResource)
    }
}

/**
 * SSL certificate purchase order.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Example Usage
 * ### Create Certificate order
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceCertificateOrder = new AzureNative.CertificateRegistration.AppServiceCertificateOrder("appServiceCertificateOrder", new()
 *     {
 *         AutoRenew = true,
 *         CertificateOrderName = "SampleCertificateOrderName",
 *         Certificates =
 *         {
 *             { "SampleCertName1", new AzureNative.CertificateRegistration.Inputs.AppServiceCertificateArgs
 *             {
 *                 KeyVaultId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName",
 *                 KeyVaultSecretName = "SampleSecretName1",
 *             } },
 *             { "SampleCertName2", new AzureNative.CertificateRegistration.Inputs.AppServiceCertificateArgs
 *             {
 *                 KeyVaultId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName",
 *                 KeyVaultSecretName = "SampleSecretName2",
 *             } },
 *         },
 *         DistinguishedName = "CN=SampleCustomDomain.com",
 *         KeySize = 2048,
 *         Location = "Global",
 *         ProductType = AzureNative.CertificateRegistration.CertificateProductType.StandardDomainValidatedSsl,
 *         ResourceGroupName = "testrg123",
 *         ValidityInYears = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/certificateregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := certificateregistration.NewAppServiceCertificateOrder(ctx, "appServiceCertificateOrder", &certificateregistration.AppServiceCertificateOrderArgs{
 * 			AutoRenew:            pulumi.Bool(true),
 * 			CertificateOrderName: pulumi.String("SampleCertificateOrderName"),
 * 			Certificates: certificateregistration.AppServiceCertificateMap{
 * 				"SampleCertName1": &certificateregistration.AppServiceCertificateArgs{
 * 					KeyVaultId:         pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 * 					KeyVaultSecretName: pulumi.String("SampleSecretName1"),
 * 				},
 * 				"SampleCertName2": &certificateregistration.AppServiceCertificateArgs{
 * 					KeyVaultId:         pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 * 					KeyVaultSecretName: pulumi.String("SampleSecretName2"),
 * 				},
 * 			},
 * 			DistinguishedName: pulumi.String("CN=SampleCustomDomain.com"),
 * 			KeySize:           pulumi.Int(2048),
 * 			Location:          pulumi.String("Global"),
 * 			ProductType:       certificateregistration.CertificateProductTypeStandardDomainValidatedSsl,
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			ValidityInYears:   pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrder;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceCertificateOrder = new AppServiceCertificateOrder("appServiceCertificateOrder", AppServiceCertificateOrderArgs.builder()
 *             .autoRenew(true)
 *             .certificateOrderName("SampleCertificateOrderName")
 *             .certificates(Map.ofEntries(
 *                 Map.entry("SampleCertName1", Map.ofEntries(
 *                     Map.entry("keyVaultId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 *                     Map.entry("keyVaultSecretName", "SampleSecretName1")
 *                 )),
 *                 Map.entry("SampleCertName2", Map.ofEntries(
 *                     Map.entry("keyVaultId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 *                     Map.entry("keyVaultSecretName", "SampleSecretName2")
 *                 ))
 *             ))
 *             .distinguishedName("CN=SampleCustomDomain.com")
 *             .keySize(2048)
 *             .location("Global")
 *             .productType("StandardDomainValidatedSsl")
 *             .resourceGroupName("testrg123")
 *             .validityInYears(2)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:certificateregistration:AppServiceCertificateOrder SampleCertificateOrderName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}
 * ```
 */
public class AppServiceCertificateOrder internal constructor(
    override val javaResource: com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrder,
) : KotlinCustomResource(javaResource, AppServiceCertificateOrderMapper) {
    /**
     * Reasons why App Service Certificate is not renewable at the current moment.
     */
    public val appServiceCertificateNotRenewableReasons: Output<List<String>>
        get() = javaResource.appServiceCertificateNotRenewableReasons().applyValue({ args0 ->
            args0.map({ args0 -> args0 })
        })

    /**
     * <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * State of the Key Vault secret.
     */
    public val certificates: Output<Map<String, AppServiceCertificateResponse>>?
        get() = javaResource.certificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            appServiceCertificateResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Contact info
     */
    public val contact: Output<CertificateOrderContactResponse>
        get() = javaResource.contact().applyValue({ args0 ->
            args0.let({ args0 ->
                certificateOrderContactResponseToKotlin(args0)
            })
        })

    /**
     * Last CSR that was created for this order.
     */
    public val csr: Output<String>?
        get() = javaResource.csr().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Certificate distinguished name.
     */
    public val distinguishedName: Output<String>?
        get() = javaResource.distinguishedName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domain verification token.
     */
    public val domainVerificationToken: Output<String>
        get() = javaResource.domainVerificationToken().applyValue({ args0 -> args0 })

    /**
     * Certificate expiration time.
     */
    public val expirationTime: Output<String>
        get() = javaResource.expirationTime().applyValue({ args0 -> args0 })

    /**
     * Intermediate certificate.
     */
    public val intermediate: Output<CertificateDetailsResponse>
        get() = javaResource.intermediate().applyValue({ args0 ->
            args0.let({ args0 ->
                certificateDetailsResponseToKotlin(args0)
            })
        })

    /**
     * <code>true</code> if private key is external; otherwise, <code>false</code>.
     */
    public val isPrivateKeyExternal: Output<Boolean>
        get() = javaResource.isPrivateKeyExternal().applyValue({ args0 -> args0 })

    /**
     * Certificate key size.
     */
    public val keySize: Output<Int>?
        get() = javaResource.keySize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Certificate last issuance time.
     */
    public val lastCertificateIssuanceTime: Output<String>
        get() = javaResource.lastCertificateIssuanceTime().applyValue({ args0 -> args0 })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Time stamp when the certificate would be auto renewed next
     */
    public val nextAutoRenewalTimeStamp: Output<String>
        get() = javaResource.nextAutoRenewalTimeStamp().applyValue({ args0 -> args0 })

    /**
     * Certificate product type.
     */
    public val productType: Output<String>
        get() = javaResource.productType().applyValue({ args0 -> args0 })

    /**
     * Status of certificate order.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Root certificate.
     */
    public val root: Output<CertificateDetailsResponse>
        get() = javaResource.root().applyValue({ args0 ->
            args0.let({ args0 ->
                certificateDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Current serial number of the certificate.
     */
    public val serialNumber: Output<String>
        get() = javaResource.serialNumber().applyValue({ args0 -> args0 })

    /**
     * Signed certificate.
     */
    public val signedCertificate: Output<CertificateDetailsResponse>
        get() = javaResource.signedCertificate().applyValue({ args0 ->
            args0.let({ args0 ->
                certificateDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Current order status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Duration in years (must be 1).
     */
    public val validityInYears: Output<Int>?
        get() = javaResource.validityInYears().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AppServiceCertificateOrderMapper : ResourceMapper<AppServiceCertificateOrder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrder::class == javaResource::class

    override fun map(javaResource: Resource): AppServiceCertificateOrder =
        AppServiceCertificateOrder(
            javaResource as
                com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrder,
        )
}

/**
 * @see [AppServiceCertificateOrder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppServiceCertificateOrder].
 */
public suspend fun appServiceCertificateOrder(
    name: String,
    block: suspend AppServiceCertificateOrderResourceBuilder.() -> Unit,
): AppServiceCertificateOrder {
    val builder = AppServiceCertificateOrderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppServiceCertificateOrder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appServiceCertificateOrder(name: String): AppServiceCertificateOrder {
    val builder = AppServiceCertificateOrderResourceBuilder()
    builder.name(name)
    return builder.build()
}
