@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Key Vault container for a certificate that is purchased through Azure.
 * @property keyVaultId Key Vault resource Id.
 * @property keyVaultSecretName Key Vault secret name.
 * @property provisioningState Status of the Key Vault secret.
 */
public data class AppServiceCertificateResponse(
    public val keyVaultId: String? = null,
    public val keyVaultSecretName: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.certificateregistration.outputs.AppServiceCertificateResponse): AppServiceCertificateResponse = AppServiceCertificateResponse(
            keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
            keyVaultSecretName = javaType.keyVaultSecretName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
