@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SSL certificate details.
 * @property issuer Certificate Issuer.
 * @property notAfter Date Certificate is valid to.
 * @property notBefore Date Certificate is valid from.
 * @property rawData Raw certificate data.
 * @property serialNumber Certificate Serial Number.
 * @property signatureAlgorithm Certificate Signature algorithm.
 * @property subject Certificate Subject.
 * @property thumbprint Certificate Thumbprint.
 * @property version Certificate Version.
 */
public data class CertificateDetailsResponse(
    public val issuer: String,
    public val notAfter: String,
    public val notBefore: String,
    public val rawData: String,
    public val serialNumber: String,
    public val signatureAlgorithm: String,
    public val subject: String,
    public val thumbprint: String,
    public val version: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.certificateregistration.outputs.CertificateDetailsResponse): CertificateDetailsResponse = CertificateDetailsResponse(
            issuer = javaType.issuer(),
            notAfter = javaType.notAfter(),
            notBefore = javaType.notBefore(),
            rawData = javaType.rawData(),
            serialNumber = javaType.serialNumber(),
            signatureAlgorithm = javaType.signatureAlgorithm(),
            subject = javaType.subject(),
            thumbprint = javaType.thumbprint(),
            version = javaType.version(),
        )
    }
}
