@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Key Vault container ARM resource for a certificate that is purchased through Azure.
 * @property id Resource Id.
 * @property keyVaultId Key Vault resource Id.
 * @property keyVaultSecretName Key Vault secret name.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property name Resource Name.
 * @property provisioningState Status of the Key Vault secret.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetAppServiceCertificateOrderCertificateResult(
    public val id: String,
    public val keyVaultId: String? = null,
    public val keyVaultSecretName: String? = null,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.certificateregistration.outputs.GetAppServiceCertificateOrderCertificateResult): GetAppServiceCertificateOrderCertificateResult =
            GetAppServiceCertificateOrderCertificateResult(
                id = javaType.id(),
                keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
                keyVaultSecretName = javaType.keyVaultSecretName().map({ args0 -> args0 }).orElse(null),
                kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
                location = javaType.location(),
                name = javaType.name(),
                provisioningState = javaType.provisioningState(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
