@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * SSL certificate purchase order.
 * @property appServiceCertificateNotRenewableReasons Reasons why App Service Certificate is not renewable at the current moment.
 * @property autoRenew <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
 * @property certificates State of the Key Vault secret.
 * @property contact Contact info
 * @property csr Last CSR that was created for this order.
 * @property distinguishedName Certificate distinguished name.
 * @property domainVerificationToken Domain verification token.
 * @property expirationTime Certificate expiration time.
 * @property id Resource Id.
 * @property intermediate Intermediate certificate.
 * @property isPrivateKeyExternal <code>true</code> if private key is external; otherwise, <code>false</code>.
 * @property keySize Certificate key size.
 * @property kind Kind of resource.
 * @property lastCertificateIssuanceTime Certificate last issuance time.
 * @property location Resource Location.
 * @property name Resource Name.
 * @property nextAutoRenewalTimeStamp Time stamp when the certificate would be auto renewed next
 * @property productType Certificate product type.
 * @property provisioningState Status of certificate order.
 * @property root Root certificate.
 * @property serialNumber Current serial number of the certificate.
 * @property signedCertificate Signed certificate.
 * @property status Current order status.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property validityInYears Duration in years (must be 1).
 */
public data class GetAppServiceCertificateOrderResult(
    public val appServiceCertificateNotRenewableReasons: List<String>,
    public val autoRenew: Boolean? = null,
    public val certificates: Map<String, AppServiceCertificateResponse>? = null,
    public val contact: CertificateOrderContactResponse,
    public val csr: String? = null,
    public val distinguishedName: String? = null,
    public val domainVerificationToken: String,
    public val expirationTime: String,
    public val id: String,
    public val intermediate: CertificateDetailsResponse,
    public val isPrivateKeyExternal: Boolean,
    public val keySize: Int? = null,
    public val kind: String? = null,
    public val lastCertificateIssuanceTime: String,
    public val location: String,
    public val name: String,
    public val nextAutoRenewalTimeStamp: String,
    public val productType: String,
    public val provisioningState: String,
    public val root: CertificateDetailsResponse,
    public val serialNumber: String,
    public val signedCertificate: CertificateDetailsResponse,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val validityInYears: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.certificateregistration.outputs.GetAppServiceCertificateOrderResult): GetAppServiceCertificateOrderResult = GetAppServiceCertificateOrderResult(
            appServiceCertificateNotRenewableReasons = javaType.appServiceCertificateNotRenewableReasons().map({ args0 ->
                args0
            }),
            autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
            certificates = javaType.certificates().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.certificateregistration.kotlin.outputs.AppServiceCertificateResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            contact = javaType.contact().let({ args0 ->
                com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateOrderContactResponse.Companion.toKotlin(args0)
            }),
            csr = javaType.csr().map({ args0 -> args0 }).orElse(null),
            distinguishedName = javaType.distinguishedName().map({ args0 -> args0 }).orElse(null),
            domainVerificationToken = javaType.domainVerificationToken(),
            expirationTime = javaType.expirationTime(),
            id = javaType.id(),
            intermediate = javaType.intermediate().let({ args0 ->
                com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateDetailsResponse.Companion.toKotlin(args0)
            }),
            isPrivateKeyExternal = javaType.isPrivateKeyExternal(),
            keySize = javaType.keySize().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            lastCertificateIssuanceTime = javaType.lastCertificateIssuanceTime(),
            location = javaType.location(),
            name = javaType.name(),
            nextAutoRenewalTimeStamp = javaType.nextAutoRenewalTimeStamp(),
            productType = javaType.productType(),
            provisioningState = javaType.provisioningState(),
            root = javaType.root().let({ args0 ->
                com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateDetailsResponse.Companion.toKotlin(args0)
            }),
            serialNumber = javaType.serialNumber(),
            signedCertificate = javaType.signedCertificate().let({ args0 ->
                com.pulumi.azurenative.certificateregistration.kotlin.outputs.CertificateDetailsResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            validityInYears = javaType.validityInYears().map({ args0 -> args0 }).orElse(null),
        )
    }
}
