@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration properties of an Azure Monitor workspace that receives change notifications.
 * @property includeChangeDetails The mode of includeChangeDetails feature. The flag configures whether to include or exclude content of the change before and after values.
 * @property workspaceId The Azure Monitor workspace ID - the unique identifier for the Log Analytics workspace.
 * @property workspaceResourceId The Azure Monitor workspace ARM Resource ID. The resource ID should be in the following format: /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}
 */
public data class AzureMonitorWorkspacePropertiesResponse(
    public val includeChangeDetails: String? = null,
    public val workspaceId: String? = null,
    public val workspaceResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.changeanalysis.outputs.AzureMonitorWorkspacePropertiesResponse): AzureMonitorWorkspacePropertiesResponse = AzureMonitorWorkspacePropertiesResponse(
            includeChangeDetails = javaType.includeChangeDetails().map({ args0 -> args0 }).orElse(null),
            workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
            workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
