@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The identity block returned by ARM resource that supports managed identity.
 * @property principalId The principal id of the identity. This property will only be provided for a system-assigned identity.
 * @property tenantId The tenant id associated with the resource's identity. This property will only be provided for a system-assigned identity.
 * @property type The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
 */
public data class ResourceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.changeanalysis.outputs.ResourceIdentityResponse): ResourceIdentityResponse = ResourceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
