@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.kotlin.outputs.CapabilityPropertiesResponse
import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.chaos.kotlin.outputs.CapabilityPropertiesResponse.Companion.toKotlin as capabilityPropertiesResponseToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Capability].
 */
@PulumiTagMarker
public class CapabilityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapabilityArgs = CapabilityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapabilityArgsBuilder.() -> Unit) {
        val builder = CapabilityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Capability {
        val builtJavaResource = com.pulumi.azurenative.chaos.Capability(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Capability(builtJavaResource)
    }
}

/**
 * Model that represents a Capability resource.
 * Azure REST API version: 2023-04-15-preview. Prior API version in Azure Native 1.x: 2021-09-15-preview.
 * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01, 2024-01-01, 2024-03-22-preview.
 * ## Example Usage
 * ### Create/update a Capability that extends a virtual machine Target resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capability = new AzureNative.Chaos.Capability("capability", new()
 *     {
 *         CapabilityName = "Shutdown-1.0",
 *         ParentProviderNamespace = "Microsoft.Compute",
 *         ParentResourceName = "exampleVM",
 *         ParentResourceType = "virtualMachines",
 *         ResourceGroupName = "exampleRG",
 *         TargetName = "Microsoft-VirtualMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/chaos/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chaos.NewCapability(ctx, "capability", &chaos.CapabilityArgs{
 * 			CapabilityName:          pulumi.String("Shutdown-1.0"),
 * 			ParentProviderNamespace: pulumi.String("Microsoft.Compute"),
 * 			ParentResourceName:      pulumi.String("exampleVM"),
 * 			ParentResourceType:      pulumi.String("virtualMachines"),
 * 			ResourceGroupName:       pulumi.String("exampleRG"),
 * 			TargetName:              pulumi.String("Microsoft-VirtualMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.chaos.Capability;
 * import com.pulumi.azurenative.chaos.CapabilityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capability = new Capability("capability", CapabilityArgs.builder()
 *             .capabilityName("Shutdown-1.0")
 *             .parentProviderNamespace("Microsoft.Compute")
 *             .parentResourceName("exampleVM")
 *             .parentResourceType("virtualMachines")
 *             .resourceGroupName("exampleRG")
 *             .targetName("Microsoft-VirtualMachine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:chaos:Capability Shutdown-1.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}
 * ```
 */
public class Capability internal constructor(
    override val javaResource: com.pulumi.azurenative.chaos.Capability,
) : KotlinCustomResource(javaResource, CapabilityMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of a capability resource.
     */
    public val properties: Output<CapabilityPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                capabilityPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The standard system metadata of a resource type.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CapabilityMapper : ResourceMapper<Capability> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.chaos.Capability::class == javaResource::class

    override fun map(javaResource: Resource): Capability = Capability(
        javaResource as
            com.pulumi.azurenative.chaos.Capability,
    )
}

/**
 * @see [Capability].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Capability].
 */
public suspend fun capability(name: String, block: suspend CapabilityResourceBuilder.() -> Unit): Capability {
    val builder = CapabilityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Capability].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capability(name: String): Capability {
    val builder = CapabilityResourceBuilder()
    builder.name(name)
    return builder.build()
}
