@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.CapabilityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model that represents a Capability resource.
 * Azure REST API version: 2023-04-15-preview. Prior API version in Azure Native 1.x: 2021-09-15-preview.
 * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01, 2024-01-01, 2024-03-22-preview.
 * ## Example Usage
 * ### Create/update a Capability that extends a virtual machine Target resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capability = new AzureNative.Chaos.Capability("capability", new()
 *     {
 *         CapabilityName = "Shutdown-1.0",
 *         ParentProviderNamespace = "Microsoft.Compute",
 *         ParentResourceName = "exampleVM",
 *         ParentResourceType = "virtualMachines",
 *         ResourceGroupName = "exampleRG",
 *         TargetName = "Microsoft-VirtualMachine",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/chaos/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chaos.NewCapability(ctx, "capability", &chaos.CapabilityArgs{
 * 			CapabilityName:          pulumi.String("Shutdown-1.0"),
 * 			ParentProviderNamespace: pulumi.String("Microsoft.Compute"),
 * 			ParentResourceName:      pulumi.String("exampleVM"),
 * 			ParentResourceType:      pulumi.String("virtualMachines"),
 * 			ResourceGroupName:       pulumi.String("exampleRG"),
 * 			TargetName:              pulumi.String("Microsoft-VirtualMachine"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.chaos.Capability;
 * import com.pulumi.azurenative.chaos.CapabilityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capability = new Capability("capability", CapabilityArgs.builder()
 *             .capabilityName("Shutdown-1.0")
 *             .parentProviderNamespace("Microsoft.Compute")
 *             .parentResourceName("exampleVM")
 *             .parentResourceType("virtualMachines")
 *             .resourceGroupName("exampleRG")
 *             .targetName("Microsoft-VirtualMachine")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:chaos:Capability Shutdown-1.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}/capabilities/{capabilityName}
 * ```
 * @property capabilityName String that represents a Capability resource name.
 * @property parentProviderNamespace String that represents a resource provider namespace.
 * @property parentResourceName String that represents a resource name.
 * @property parentResourceType String that represents a resource type.
 * @property resourceGroupName String that represents an Azure resource group.
 * @property targetName String that represents a Target resource name.
 */
public data class CapabilityArgs(
    public val capabilityName: Output<String>? = null,
    public val parentProviderNamespace: Output<String>? = null,
    public val parentResourceName: Output<String>? = null,
    public val parentResourceType: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val targetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.CapabilityArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.CapabilityArgs =
        com.pulumi.azurenative.chaos.CapabilityArgs.builder()
            .capabilityName(capabilityName?.applyValue({ args0 -> args0 }))
            .parentProviderNamespace(parentProviderNamespace?.applyValue({ args0 -> args0 }))
            .parentResourceName(parentResourceName?.applyValue({ args0 -> args0 }))
            .parentResourceType(parentResourceType?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .targetName(targetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CapabilityArgs].
 */
@PulumiTagMarker
public class CapabilityArgsBuilder internal constructor() {
    private var capabilityName: Output<String>? = null

    private var parentProviderNamespace: Output<String>? = null

    private var parentResourceName: Output<String>? = null

    private var parentResourceType: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var targetName: Output<String>? = null

    /**
     * @param value String that represents a Capability resource name.
     */
    @JvmName("abvtbprbynnioqan")
    public suspend fun capabilityName(`value`: Output<String>) {
        this.capabilityName = value
    }

    /**
     * @param value String that represents a resource provider namespace.
     */
    @JvmName("lktruipdhfajddkg")
    public suspend fun parentProviderNamespace(`value`: Output<String>) {
        this.parentProviderNamespace = value
    }

    /**
     * @param value String that represents a resource name.
     */
    @JvmName("etturowlwaqmjhjm")
    public suspend fun parentResourceName(`value`: Output<String>) {
        this.parentResourceName = value
    }

    /**
     * @param value String that represents a resource type.
     */
    @JvmName("ejidraafpxctjqum")
    public suspend fun parentResourceType(`value`: Output<String>) {
        this.parentResourceType = value
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("agjhkpkfbvhpmpxt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value String that represents a Target resource name.
     */
    @JvmName("tgwxgquhjsbcubpe")
    public suspend fun targetName(`value`: Output<String>) {
        this.targetName = value
    }

    /**
     * @param value String that represents a Capability resource name.
     */
    @JvmName("ncbhrgtrgphvxfgi")
    public suspend fun capabilityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilityName = mapped
    }

    /**
     * @param value String that represents a resource provider namespace.
     */
    @JvmName("ohgploidwhxiincf")
    public suspend fun parentProviderNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentProviderNamespace = mapped
    }

    /**
     * @param value String that represents a resource name.
     */
    @JvmName("ougvktdmofifciqm")
    public suspend fun parentResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResourceName = mapped
    }

    /**
     * @param value String that represents a resource type.
     */
    @JvmName("scoefqrxrdcrtqth")
    public suspend fun parentResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResourceType = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("ppnxtuwdilklefpi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value String that represents a Target resource name.
     */
    @JvmName("kjrrtxbxldujicqe")
    public suspend fun targetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    internal fun build(): CapabilityArgs = CapabilityArgs(
        capabilityName = capabilityName,
        parentProviderNamespace = parentProviderNamespace,
        parentResourceName = parentResourceName,
        parentResourceType = parentResourceType,
        resourceGroupName = resourceGroupName,
        targetName = targetName,
    )
}
