@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.ExperimentArgs.builder
import com.pulumi.azurenative.chaos.kotlin.inputs.ExperimentPropertiesArgs
import com.pulumi.azurenative.chaos.kotlin.inputs.ExperimentPropertiesArgsBuilder
import com.pulumi.azurenative.chaos.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.chaos.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Model that represents a Experiment resource.
 * Azure REST API version: 2023-04-15-preview. Prior API version in Azure Native 1.x: 2021-09-15-preview.
 * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01, 2024-01-01, 2024-03-22-preview.
 * @property experimentName String that represents a Experiment resource name.
 * @property identity The identity of the experiment resource.
 * @property location The geo-location where the resource lives
 * @property properties The properties of the experiment resource.
 * @property resourceGroupName String that represents an Azure resource group.
 * @property tags Resource tags.
 */
public data class ExperimentArgs(
    public val experimentName: Output<String>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ExperimentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.ExperimentArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.ExperimentArgs =
        com.pulumi.azurenative.chaos.ExperimentArgs.builder()
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExperimentArgs].
 */
@PulumiTagMarker
public class ExperimentArgsBuilder internal constructor() {
    private var experimentName: Output<String>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<ExperimentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value String that represents a Experiment resource name.
     */
    @JvmName("sxonsomyudpgrmfb")
    public suspend fun experimentName(`value`: Output<String>) {
        this.experimentName = value
    }

    /**
     * @param value The identity of the experiment resource.
     */
    @JvmName("bxakbmluwsguywna")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dbfckqgxiltvjaxi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The properties of the experiment resource.
     */
    @JvmName("pviifqmdasifxdpo")
    public suspend fun properties(`value`: Output<ExperimentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("rflijfipqswldsbn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hwiwbkwwufniapcv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value String that represents a Experiment resource name.
     */
    @JvmName("yibcwertxhtqfcvd")
    public suspend fun experimentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value The identity of the experiment resource.
     */
    @JvmName("tkrowsqytpkhygoe")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the experiment resource.
     */
    @JvmName("idvkpogifaulmqpd")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hvjybqkfvgdaqohi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The properties of the experiment resource.
     */
    @JvmName("uyvcrrxtputrwehd")
    public suspend fun properties(`value`: ExperimentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of the experiment resource.
     */
    @JvmName("kjwacrwoyqlktyei")
    public suspend fun properties(argument: suspend ExperimentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("pxynhsdhqsyhpimb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hrtcfwjmcjdudphx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lmgyeodefqacyjyk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ExperimentArgs = ExperimentArgs(
        experimentName = experimentName,
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
