@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.PrivateAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * PrivateAccesses tracked resource.
 * Azure REST API version: 2023-10-27-preview.
 * Other available API versions: 2024-03-22-preview.
 * ## Example Usage
 * ### Create or Update a private access resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateAccess = new AzureNative.Chaos.PrivateAccess("privateAccess", new()
 *     {
 *         Location = "centraluseuap",
 *         PrivateAccessName = "myPrivateAccess",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/chaos/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chaos.NewPrivateAccess(ctx, "privateAccess", &chaos.PrivateAccessArgs{
 * 			Location:          pulumi.String("centraluseuap"),
 * 			PrivateAccessName: pulumi.String("myPrivateAccess"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.chaos.PrivateAccess;
 * import com.pulumi.azurenative.chaos.PrivateAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateAccess = new PrivateAccess("privateAccess", PrivateAccessArgs.builder()
 *             .location("centraluseuap")
 *             .privateAccessName("myPrivateAccess")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:chaos:PrivateAccess myPrivateAccess /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Chaos/privateAccesses/{privateAccessName}
 * ```
 * @property location The geo-location where the resource lives
 * @property privateAccessName The name of the private access resource that is being created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property resourceGroupName String that represents an Azure resource group.
 * @property tags Resource tags.
 */
public data class PrivateAccessArgs(
    public val location: Output<String>? = null,
    public val privateAccessName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.PrivateAccessArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.PrivateAccessArgs =
        com.pulumi.azurenative.chaos.PrivateAccessArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .privateAccessName(privateAccessName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateAccessArgs].
 */
@PulumiTagMarker
public class PrivateAccessArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var privateAccessName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("anmwjugxwnqmvltt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the private access resource that is being created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("xkwbevsqsxrjbmpe")
    public suspend fun privateAccessName(`value`: Output<String>) {
        this.privateAccessName = value
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("brmeosqjuqhctnww")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cxpeygeqvdtrcnci")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xkehyvelavbwjdne")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the private access resource that is being created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("fdqvnhabujnvjopv")
    public suspend fun privateAccessName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateAccessName = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("kxjdsleecdrugtel")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("snypwkfnebvaxtbf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("pjxcbivxbhnekpqv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateAccessArgs = PrivateAccessArgs(
        location = location,
        privateAccessName = privateAccessName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
