@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.GetPrivateAccessPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateAccessName The name of the private access resource that is being created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property resourceGroupName String that represents an Azure resource group.
 */
public data class GetPrivateAccessPlainArgs(
    public val privateAccessName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.GetPrivateAccessPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.GetPrivateAccessPlainArgs =
        com.pulumi.azurenative.chaos.inputs.GetPrivateAccessPlainArgs.builder()
            .privateAccessName(privateAccessName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateAccessPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateAccessPlainArgsBuilder internal constructor() {
    private var privateAccessName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the private access resource that is being created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("ogqsirimacejnpfq")
    public suspend fun privateAccessName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateAccessName = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("uwpnmsiuxucftjfm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateAccessPlainArgs = GetPrivateAccessPlainArgs(
        privateAccessName = privateAccessName ?: throw PulumiNullFieldException("privateAccessName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
