@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.ListSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents a list selector.
 * @property filter Model that represents available filter types that can be applied to a targets list.
 * @property id String of the selector ID.
 * @property targets List of Target references.
 * @property type Enum of the selector type.
 * Expected value is 'List'.
 */
public data class ListSelectorArgs(
    public val filter: Output<SimpleFilterArgs>? = null,
    public val id: Output<String>,
    public val targets: Output<List<TargetReferenceArgs>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.ListSelectorArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.ListSelectorArgs =
        com.pulumi.azurenative.chaos.inputs.ListSelectorArgs.builder()
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id.applyValue({ args0 -> args0 }))
            .targets(
                targets.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSelectorArgs].
 */
@PulumiTagMarker
public class ListSelectorArgsBuilder internal constructor() {
    private var filter: Output<SimpleFilterArgs>? = null

    private var id: Output<String>? = null

    private var targets: Output<List<TargetReferenceArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Model that represents available filter types that can be applied to a targets list.
     */
    @JvmName("ulpdqjfuhchdtbtt")
    public suspend fun filter(`value`: Output<SimpleFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value String of the selector ID.
     */
    @JvmName("dpbuhvupcaiklovw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of Target references.
     */
    @JvmName("frstcfxbtbjxdbgu")
    public suspend fun targets(`value`: Output<List<TargetReferenceArgs>>) {
        this.targets = value
    }

    @JvmName("rfwgbdcmcetpqlhq")
    public suspend fun targets(vararg values: Output<TargetReferenceArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values List of Target references.
     */
    @JvmName("dfltcfidjpxcyrfl")
    public suspend fun targets(values: List<Output<TargetReferenceArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value Enum of the selector type.
     * Expected value is 'List'.
     */
    @JvmName("uoikttlhjooiikul")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Model that represents available filter types that can be applied to a targets list.
     */
    @JvmName("tdljapnlbfhvqkbr")
    public suspend fun filter(`value`: SimpleFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Model that represents available filter types that can be applied to a targets list.
     */
    @JvmName("hvjhiurpcvkckkqi")
    public suspend fun filter(argument: suspend SimpleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = SimpleFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value String of the selector ID.
     */
    @JvmName("oaepjdchasfuqira")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of Target references.
     */
    @JvmName("yyhiyglbdaotkkwq")
    public suspend fun targets(`value`: List<TargetReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument List of Target references.
     */
    @JvmName("jidfvidabymhaafm")
    public suspend fun targets(argument: List<suspend TargetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument List of Target references.
     */
    @JvmName("nxfuvtdjpmvsoqoo")
    public suspend fun targets(vararg argument: suspend TargetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument List of Target references.
     */
    @JvmName("nuwhyxsnoxpmpebd")
    public suspend fun targets(argument: suspend TargetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values List of Target references.
     */
    @JvmName("vkihxwnbmxcclekp")
    public suspend fun targets(vararg values: TargetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value Enum of the selector type.
     * Expected value is 'List'.
     */
    @JvmName("ofwcpocotdqyomqq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ListSelectorArgs = ListSelectorArgs(
        filter = filter,
        id = id ?: throw PulumiNullFieldException("id"),
        targets = targets ?: throw PulumiNullFieldException("targets"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
