@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents a branch in the step.
 * @property actions List of actions.
 * @property name String of the branch name.
 */
public data class BranchResponse(
    public val actions: List<Any>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.BranchResponse): BranchResponse = BranchResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            name = javaType.name(),
        )
    }
}
