@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model that represents the Capability properties model.
 * @property description Localized string of the description.
 * @property parametersSchema URL to retrieve JSON schema of the Capability parameters.
 * @property publisher String of the Publisher that this Capability extends.
 * @property targetType String of the Target Type that this Capability extends.
 * @property urn String of the URN for this Capability Type.
 */
public data class CapabilityPropertiesResponse(
    public val description: String,
    public val parametersSchema: String,
    public val publisher: String,
    public val targetType: String,
    public val urn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.CapabilityPropertiesResponse): CapabilityPropertiesResponse = CapabilityPropertiesResponse(
            description = javaType.description(),
            parametersSchema = javaType.parametersSchema(),
            publisher = javaType.publisher(),
            targetType = javaType.targetType(),
            urn = javaType.urn(),
        )
    }
}
