@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model that represents a delay action.
 * @property duration ISO8601 formatted string that represents a duration.
 * @property name String that represents a Capability URN.
 * @property type Enum that discriminates between action models.
 * Expected value is 'delay'.
 */
public data class DelayActionResponse(
    public val duration: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.DelayActionResponse): DelayActionResponse = DelayActionResponse(
            duration = javaType.duration(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
