@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model that represents the Experiment action target details error model.
 * @property code The error code.
 * @property message The error message
 */
public data class ExperimentExecutionActionTargetDetailsErrorResponse(
    public val code: String,
    public val message: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.ExperimentExecutionActionTargetDetailsErrorResponse): ExperimentExecutionActionTargetDetailsErrorResponse =
            ExperimentExecutionActionTargetDetailsErrorResponse(
                code = javaType.code(),
                message = javaType.message(),
            )
    }
}
