@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents the Experiment properties model.
 * @property selectors List of selectors.
 * @property startOnCreation A boolean value that indicates if experiment should be started on creation or not.
 * @property steps List of steps.
 */
public data class ExperimentPropertiesResponse(
    public val selectors: List<Either<ListSelectorResponse, QuerySelectorResponse>>,
    public val startOnCreation: Boolean? = null,
    public val steps: List<StepResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.ExperimentPropertiesResponse): ExperimentPropertiesResponse = ExperimentPropertiesResponse(
            selectors = javaType.selectors().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.chaos.kotlin.outputs.ListSelectorResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.chaos.kotlin.outputs.QuerySelectorResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            startOnCreation = javaType.startOnCreation().map({ args0 -> args0 }).orElse(null),
            steps = javaType.steps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.StepResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
