@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CertificateObjectGlobalRulestack].
 */
@PulumiTagMarker
public class CertificateObjectGlobalRulestackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateObjectGlobalRulestackArgs = CertificateObjectGlobalRulestackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateObjectGlobalRulestackArgsBuilder.() -> Unit) {
        val builder = CertificateObjectGlobalRulestackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CertificateObjectGlobalRulestack {
        val builtJavaResource =
            com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CertificateObjectGlobalRulestack(builtJavaResource)
    }
}

/**
 * GlobalRulestack Certificate Object
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### CertificateObjectGlobalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateObjectGlobalRulestack = new AzureNative.Cloudngfw.CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", new()
 *     {
 *         AuditComment = "comment",
 *         CertificateSelfSigned = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         CertificateSignerResourceId = "",
 *         Description = "description",
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewCertificateObjectGlobalRulestack(ctx, "certificateObjectGlobalRulestack", &cloudngfw.CertificateObjectGlobalRulestackArgs{
 * 			AuditComment:                pulumi.String("comment"),
 * 			CertificateSelfSigned:       pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			CertificateSignerResourceId: pulumi.String(""),
 * 			Description:                 pulumi.String("description"),
 * 			GlobalRulestackName:         pulumi.String("praval"),
 * 			Name:                        pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateObjectGlobalRulestack = new CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", CertificateObjectGlobalRulestackArgs.builder()
 *             .auditComment("comment")
 *             .certificateSelfSigned("TRUE")
 *             .certificateSignerResourceId("")
 *             .description("description")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ### CertificateObjectGlobalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificateObjectGlobalRulestack = new AzureNative.Cloudngfw.CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", new()
 *     {
 *         CertificateSelfSigned = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewCertificateObjectGlobalRulestack(ctx, "certificateObjectGlobalRulestack", &cloudngfw.CertificateObjectGlobalRulestackArgs{
 * 			CertificateSelfSigned: pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			GlobalRulestackName:   pulumi.String("praval"),
 * 			Name:                  pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificateObjectGlobalRulestack = new CertificateObjectGlobalRulestack("certificateObjectGlobalRulestack", CertificateObjectGlobalRulestackArgs.builder()
 *             .certificateSelfSigned("TRUE")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:CertificateObjectGlobalRulestack armid1 /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/certificates/{name}
 * ```
 */
public class CertificateObjectGlobalRulestack internal constructor(
    override val javaResource: com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack,
) : KotlinCustomResource(javaResource, CertificateObjectGlobalRulestackMapper) {
    /**
     * comment for this object
     */
    public val auditComment: Output<String>?
        get() = javaResource.auditComment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * use certificate self signed
     */
    public val certificateSelfSigned: Output<String>
        get() = javaResource.certificateSelfSigned().applyValue({ args0 -> args0 })

    /**
     * Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
     */
    public val certificateSignerResourceId: Output<String>?
        get() = javaResource.certificateSignerResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * user description for this object
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * read only string representing last create or update
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CertificateObjectGlobalRulestackMapper :
    ResourceMapper<CertificateObjectGlobalRulestack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack::class == javaResource::class

    override fun map(javaResource: Resource): CertificateObjectGlobalRulestack =
        CertificateObjectGlobalRulestack(
            javaResource as
                com.pulumi.azurenative.cloudngfw.CertificateObjectGlobalRulestack,
        )
}

/**
 * @see [CertificateObjectGlobalRulestack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CertificateObjectGlobalRulestack].
 */
public suspend fun certificateObjectGlobalRulestack(
    name: String,
    block: suspend CertificateObjectGlobalRulestackResourceBuilder.() -> Unit,
): CertificateObjectGlobalRulestack {
    val builder = CertificateObjectGlobalRulestackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CertificateObjectGlobalRulestack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificateObjectGlobalRulestack(name: String): CertificateObjectGlobalRulestack {
    val builder = CertificateObjectGlobalRulestackResourceBuilder()
    builder.name(name)
    return builder.build()
}
