@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getCertificateObjectGlobalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getCertificateObjectLocalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getFirewallGlobalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getFirewallLogProfilePlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getFirewallPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getFirewallSupportInfoPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getFqdnListGlobalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getFqdnListLocalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getGlobalRulestackChangeLogPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getGlobalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getLocalRuleCountersPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getLocalRulePlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getLocalRulestackChangeLogPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getLocalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getLocalRulestackSupportInfoPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getPostRuleCountersPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getPostRulePlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getPreRuleCountersPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getPreRulePlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getPrefixListGlobalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.getPrefixListLocalRulestackPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listGlobalRulestackAdvancedSecurityObjectsPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listGlobalRulestackAppIdsPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listGlobalRulestackCountriesPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listGlobalRulestackFirewallsPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listGlobalRulestackPredefinedUrlCategoriesPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listGlobalRulestackSecurityServicesPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listLocalRulestackAdvancedSecurityObjectsPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listLocalRulestackAppIdsPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listLocalRulestackCountriesPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listLocalRulestackFirewallsPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listLocalRulestackPredefinedUrlCategoriesPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listLocalRulestackSecurityServicesPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listPaloAltoNetworksCloudngfwCloudManagerTenantsPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listPaloAltoNetworksCloudngfwProductSerialNumberStatusPlain
import com.pulumi.azurenative.cloudngfw.CloudngfwFunctions.listPaloAltoNetworksCloudngfwSupportInfoPlain
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetCertificateObjectGlobalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetCertificateObjectGlobalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetCertificateObjectLocalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetCertificateObjectLocalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallGlobalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallGlobalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallLogProfilePlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallLogProfilePlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallSupportInfoPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFirewallSupportInfoPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFqdnListGlobalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFqdnListGlobalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFqdnListLocalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetFqdnListLocalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetGlobalRulestackChangeLogPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetGlobalRulestackChangeLogPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetGlobalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetGlobalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRuleCountersPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRuleCountersPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulePlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulePlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulestackChangeLogPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulestackChangeLogPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulestackSupportInfoPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetLocalRulestackSupportInfoPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPostRuleCountersPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPostRuleCountersPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPostRulePlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPostRulePlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPreRuleCountersPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPreRuleCountersPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPreRulePlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPreRulePlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPrefixListGlobalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPrefixListGlobalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPrefixListLocalRulestackPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.GetPrefixListLocalRulestackPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackAdvancedSecurityObjectsPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackAdvancedSecurityObjectsPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackAppIdsPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackAppIdsPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackCountriesPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackCountriesPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackFirewallsPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackFirewallsPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackPredefinedUrlCategoriesPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackPredefinedUrlCategoriesPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackSecurityServicesPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListGlobalRulestackSecurityServicesPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackAdvancedSecurityObjectsPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackAdvancedSecurityObjectsPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackAppIdsPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackAppIdsPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackCountriesPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackCountriesPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackFirewallsPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackFirewallsPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackPredefinedUrlCategoriesPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackPredefinedUrlCategoriesPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackSecurityServicesPlainArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.ListLocalRulestackSecurityServicesPlainArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetCertificateObjectGlobalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetCertificateObjectLocalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallGlobalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallLogProfileResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallSupportInfoResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFqdnListGlobalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFqdnListLocalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetGlobalRulestackChangeLogResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetGlobalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRuleCountersResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRuleResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRulestackChangeLogResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRulestackSupportInfoResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPostRuleCountersResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPostRuleResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPreRuleCountersResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPreRuleResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPrefixListGlobalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPrefixListLocalRulestackResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackAdvancedSecurityObjectsResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackAppIdsResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackCountriesResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackFirewallsResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackPredefinedUrlCategoriesResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackSecurityServicesResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackAdvancedSecurityObjectsResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackAppIdsResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackCountriesResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackFirewallsResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackPredefinedUrlCategoriesResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackSecurityServicesResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListPaloAltoNetworksCloudngfwCloudManagerTenantsResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListPaloAltoNetworksCloudngfwProductSerialNumberStatusResult
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListPaloAltoNetworksCloudngfwSupportInfoResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetCertificateObjectGlobalRulestackResult.Companion.toKotlin as getCertificateObjectGlobalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetCertificateObjectLocalRulestackResult.Companion.toKotlin as getCertificateObjectLocalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallGlobalRulestackResult.Companion.toKotlin as getFirewallGlobalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallLogProfileResult.Companion.toKotlin as getFirewallLogProfileResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallResult.Companion.toKotlin as getFirewallResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFirewallSupportInfoResult.Companion.toKotlin as getFirewallSupportInfoResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFqdnListGlobalRulestackResult.Companion.toKotlin as getFqdnListGlobalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetFqdnListLocalRulestackResult.Companion.toKotlin as getFqdnListLocalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetGlobalRulestackChangeLogResult.Companion.toKotlin as getGlobalRulestackChangeLogResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetGlobalRulestackResult.Companion.toKotlin as getGlobalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRuleCountersResult.Companion.toKotlin as getLocalRuleCountersResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRuleResult.Companion.toKotlin as getLocalRuleResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRulestackChangeLogResult.Companion.toKotlin as getLocalRulestackChangeLogResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRulestackResult.Companion.toKotlin as getLocalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetLocalRulestackSupportInfoResult.Companion.toKotlin as getLocalRulestackSupportInfoResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPostRuleCountersResult.Companion.toKotlin as getPostRuleCountersResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPostRuleResult.Companion.toKotlin as getPostRuleResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPreRuleCountersResult.Companion.toKotlin as getPreRuleCountersResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPreRuleResult.Companion.toKotlin as getPreRuleResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPrefixListGlobalRulestackResult.Companion.toKotlin as getPrefixListGlobalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.GetPrefixListLocalRulestackResult.Companion.toKotlin as getPrefixListLocalRulestackResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackAdvancedSecurityObjectsResult.Companion.toKotlin as listGlobalRulestackAdvancedSecurityObjectsResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackAppIdsResult.Companion.toKotlin as listGlobalRulestackAppIdsResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackCountriesResult.Companion.toKotlin as listGlobalRulestackCountriesResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackFirewallsResult.Companion.toKotlin as listGlobalRulestackFirewallsResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackPredefinedUrlCategoriesResult.Companion.toKotlin as listGlobalRulestackPredefinedUrlCategoriesResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListGlobalRulestackSecurityServicesResult.Companion.toKotlin as listGlobalRulestackSecurityServicesResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackAdvancedSecurityObjectsResult.Companion.toKotlin as listLocalRulestackAdvancedSecurityObjectsResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackAppIdsResult.Companion.toKotlin as listLocalRulestackAppIdsResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackCountriesResult.Companion.toKotlin as listLocalRulestackCountriesResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackFirewallsResult.Companion.toKotlin as listLocalRulestackFirewallsResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackPredefinedUrlCategoriesResult.Companion.toKotlin as listLocalRulestackPredefinedUrlCategoriesResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListLocalRulestackSecurityServicesResult.Companion.toKotlin as listLocalRulestackSecurityServicesResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListPaloAltoNetworksCloudngfwCloudManagerTenantsResult.Companion.toKotlin as listPaloAltoNetworksCloudngfwCloudManagerTenantsResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListPaloAltoNetworksCloudngfwProductSerialNumberStatusResult.Companion.toKotlin as listPaloAltoNetworksCloudngfwProductSerialNumberStatusResultToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.ListPaloAltoNetworksCloudngfwSupportInfoResult.Companion.toKotlin as listPaloAltoNetworksCloudngfwSupportInfoResultToKotlin

public object CloudngfwFunctions {
    /**
     * Get a CertificateObjectGlobalRulestackResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return GlobalRulestack Certificate Object
     */
    public suspend fun getCertificateObjectGlobalRulestack(argument: GetCertificateObjectGlobalRulestackPlainArgs): GetCertificateObjectGlobalRulestackResult =
        getCertificateObjectGlobalRulestackResultToKotlin(getCertificateObjectGlobalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getCertificateObjectGlobalRulestack].
     * @param globalRulestackName GlobalRulestack resource name
     * @param name certificate name
     * @return GlobalRulestack Certificate Object
     */
    public suspend fun getCertificateObjectGlobalRulestack(globalRulestackName: String, name: String): GetCertificateObjectGlobalRulestackResult {
        val argument = GetCertificateObjectGlobalRulestackPlainArgs(
            globalRulestackName = globalRulestackName,
            name = name,
        )
        return getCertificateObjectGlobalRulestackResultToKotlin(getCertificateObjectGlobalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificateObjectGlobalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetCertificateObjectGlobalRulestackPlainArgs].
     * @return GlobalRulestack Certificate Object
     */
    public suspend fun getCertificateObjectGlobalRulestack(argument: suspend GetCertificateObjectGlobalRulestackPlainArgsBuilder.() -> Unit): GetCertificateObjectGlobalRulestackResult {
        val builder = GetCertificateObjectGlobalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateObjectGlobalRulestackResultToKotlin(getCertificateObjectGlobalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a CertificateObjectLocalRulestackResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return LocalRulestack Certificate Object
     */
    public suspend fun getCertificateObjectLocalRulestack(argument: GetCertificateObjectLocalRulestackPlainArgs): GetCertificateObjectLocalRulestackResult =
        getCertificateObjectLocalRulestackResultToKotlin(getCertificateObjectLocalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getCertificateObjectLocalRulestack].
     * @param localRulestackName LocalRulestack resource name
     * @param name certificate name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return LocalRulestack Certificate Object
     */
    public suspend fun getCertificateObjectLocalRulestack(
        localRulestackName: String,
        name: String,
        resourceGroupName: String,
    ): GetCertificateObjectLocalRulestackResult {
        val argument = GetCertificateObjectLocalRulestackPlainArgs(
            localRulestackName = localRulestackName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getCertificateObjectLocalRulestackResultToKotlin(getCertificateObjectLocalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificateObjectLocalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetCertificateObjectLocalRulestackPlainArgs].
     * @return LocalRulestack Certificate Object
     */
    public suspend fun getCertificateObjectLocalRulestack(argument: suspend GetCertificateObjectLocalRulestackPlainArgsBuilder.() -> Unit): GetCertificateObjectLocalRulestackResult {
        val builder = GetCertificateObjectLocalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateObjectLocalRulestackResultToKotlin(getCertificateObjectLocalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a FirewallResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return PaloAltoNetworks Firewall
     */
    public suspend fun getFirewall(argument: GetFirewallPlainArgs): GetFirewallResult =
        getFirewallResultToKotlin(getFirewallPlain(argument.toJava()).await())

    /**
     * @see [getFirewall].
     * @param firewallName Firewall resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return PaloAltoNetworks Firewall
     */
    public suspend fun getFirewall(firewallName: String, resourceGroupName: String): GetFirewallResult {
        val argument = GetFirewallPlainArgs(
            firewallName = firewallName,
            resourceGroupName = resourceGroupName,
        )
        return getFirewallResultToKotlin(getFirewallPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewall].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetFirewallPlainArgs].
     * @return PaloAltoNetworks Firewall
     */
    public suspend fun getFirewall(argument: suspend GetFirewallPlainArgsBuilder.() -> Unit): GetFirewallResult {
        val builder = GetFirewallPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallResultToKotlin(getFirewallPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Global Rulestack associated with the Firewall
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return PAN Rulestack Describe Object
     */
    public suspend fun getFirewallGlobalRulestack(argument: GetFirewallGlobalRulestackPlainArgs): GetFirewallGlobalRulestackResult =
        getFirewallGlobalRulestackResultToKotlin(getFirewallGlobalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getFirewallGlobalRulestack].
     * @param firewallName Firewall resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return PAN Rulestack Describe Object
     */
    public suspend fun getFirewallGlobalRulestack(firewallName: String, resourceGroupName: String): GetFirewallGlobalRulestackResult {
        val argument = GetFirewallGlobalRulestackPlainArgs(
            firewallName = firewallName,
            resourceGroupName = resourceGroupName,
        )
        return getFirewallGlobalRulestackResultToKotlin(getFirewallGlobalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallGlobalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetFirewallGlobalRulestackPlainArgs].
     * @return PAN Rulestack Describe Object
     */
    public suspend fun getFirewallGlobalRulestack(argument: suspend GetFirewallGlobalRulestackPlainArgsBuilder.() -> Unit): GetFirewallGlobalRulestackResult {
        val builder = GetFirewallGlobalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallGlobalRulestackResultToKotlin(getFirewallGlobalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Log Profile for Firewall
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Log Settings for Firewall
     */
    public suspend fun getFirewallLogProfile(argument: GetFirewallLogProfilePlainArgs): GetFirewallLogProfileResult =
        getFirewallLogProfileResultToKotlin(getFirewallLogProfilePlain(argument.toJava()).await())

    /**
     * @see [getFirewallLogProfile].
     * @param firewallName Firewall resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Log Settings for Firewall
     */
    public suspend fun getFirewallLogProfile(firewallName: String, resourceGroupName: String): GetFirewallLogProfileResult {
        val argument = GetFirewallLogProfilePlainArgs(
            firewallName = firewallName,
            resourceGroupName = resourceGroupName,
        )
        return getFirewallLogProfileResultToKotlin(getFirewallLogProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallLogProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetFirewallLogProfilePlainArgs].
     * @return Log Settings for Firewall
     */
    public suspend fun getFirewallLogProfile(argument: suspend GetFirewallLogProfilePlainArgsBuilder.() -> Unit): GetFirewallLogProfileResult {
        val builder = GetFirewallLogProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallLogProfileResultToKotlin(getFirewallLogProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * support info for firewall.
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Support information for the resource
     */
    public suspend fun getFirewallSupportInfo(argument: GetFirewallSupportInfoPlainArgs): GetFirewallSupportInfoResult =
        getFirewallSupportInfoResultToKotlin(getFirewallSupportInfoPlain(argument.toJava()).await())

    /**
     * @see [getFirewallSupportInfo].
     * @param email email address on behalf of which this API called
     * @param firewallName Firewall resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Support information for the resource
     */
    public suspend fun getFirewallSupportInfo(
        email: String? = null,
        firewallName: String,
        resourceGroupName: String,
    ): GetFirewallSupportInfoResult {
        val argument = GetFirewallSupportInfoPlainArgs(
            email = email,
            firewallName = firewallName,
            resourceGroupName = resourceGroupName,
        )
        return getFirewallSupportInfoResultToKotlin(getFirewallSupportInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallSupportInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetFirewallSupportInfoPlainArgs].
     * @return Support information for the resource
     */
    public suspend fun getFirewallSupportInfo(argument: suspend GetFirewallSupportInfoPlainArgsBuilder.() -> Unit): GetFirewallSupportInfoResult {
        val builder = GetFirewallSupportInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallSupportInfoResultToKotlin(getFirewallSupportInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a FqdnListGlobalRulestackResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return GlobalRulestack fqdnList
     */
    public suspend fun getFqdnListGlobalRulestack(argument: GetFqdnListGlobalRulestackPlainArgs): GetFqdnListGlobalRulestackResult =
        getFqdnListGlobalRulestackResultToKotlin(getFqdnListGlobalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getFqdnListGlobalRulestack].
     * @param globalRulestackName GlobalRulestack resource name
     * @param name fqdn list name
     * @return GlobalRulestack fqdnList
     */
    public suspend fun getFqdnListGlobalRulestack(globalRulestackName: String, name: String): GetFqdnListGlobalRulestackResult {
        val argument = GetFqdnListGlobalRulestackPlainArgs(
            globalRulestackName = globalRulestackName,
            name = name,
        )
        return getFqdnListGlobalRulestackResultToKotlin(getFqdnListGlobalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getFqdnListGlobalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetFqdnListGlobalRulestackPlainArgs].
     * @return GlobalRulestack fqdnList
     */
    public suspend fun getFqdnListGlobalRulestack(argument: suspend GetFqdnListGlobalRulestackPlainArgsBuilder.() -> Unit): GetFqdnListGlobalRulestackResult {
        val builder = GetFqdnListGlobalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFqdnListGlobalRulestackResultToKotlin(getFqdnListGlobalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a FqdnListLocalRulestackResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return LocalRulestack fqdnList
     */
    public suspend fun getFqdnListLocalRulestack(argument: GetFqdnListLocalRulestackPlainArgs): GetFqdnListLocalRulestackResult =
        getFqdnListLocalRulestackResultToKotlin(getFqdnListLocalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getFqdnListLocalRulestack].
     * @param localRulestackName LocalRulestack resource name
     * @param name fqdn list name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return LocalRulestack fqdnList
     */
    public suspend fun getFqdnListLocalRulestack(
        localRulestackName: String,
        name: String,
        resourceGroupName: String,
    ): GetFqdnListLocalRulestackResult {
        val argument = GetFqdnListLocalRulestackPlainArgs(
            localRulestackName = localRulestackName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getFqdnListLocalRulestackResultToKotlin(getFqdnListLocalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getFqdnListLocalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetFqdnListLocalRulestackPlainArgs].
     * @return LocalRulestack fqdnList
     */
    public suspend fun getFqdnListLocalRulestack(argument: suspend GetFqdnListLocalRulestackPlainArgsBuilder.() -> Unit): GetFqdnListLocalRulestackResult {
        val builder = GetFqdnListLocalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFqdnListLocalRulestackResultToKotlin(getFqdnListLocalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a GlobalRulestackResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return PaloAltoNetworks GlobalRulestack
     */
    public suspend fun getGlobalRulestack(argument: GetGlobalRulestackPlainArgs): GetGlobalRulestackResult =
        getGlobalRulestackResultToKotlin(getGlobalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getGlobalRulestack].
     * @param globalRulestackName GlobalRulestack resource name
     * @return PaloAltoNetworks GlobalRulestack
     */
    public suspend fun getGlobalRulestack(globalRulestackName: String): GetGlobalRulestackResult {
        val argument = GetGlobalRulestackPlainArgs(
            globalRulestackName = globalRulestackName,
        )
        return getGlobalRulestackResultToKotlin(getGlobalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetGlobalRulestackPlainArgs].
     * @return PaloAltoNetworks GlobalRulestack
     */
    public suspend fun getGlobalRulestack(argument: suspend GetGlobalRulestackPlainArgsBuilder.() -> Unit): GetGlobalRulestackResult {
        val builder = GetGlobalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalRulestackResultToKotlin(getGlobalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get changelog
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Changelog list
     */
    public suspend fun getGlobalRulestackChangeLog(argument: GetGlobalRulestackChangeLogPlainArgs): GetGlobalRulestackChangeLogResult =
        getGlobalRulestackChangeLogResultToKotlin(getGlobalRulestackChangeLogPlain(argument.toJava()).await())

    /**
     * @see [getGlobalRulestackChangeLog].
     * @param globalRulestackName GlobalRulestack resource name
     * @return Changelog list
     */
    public suspend fun getGlobalRulestackChangeLog(globalRulestackName: String): GetGlobalRulestackChangeLogResult {
        val argument = GetGlobalRulestackChangeLogPlainArgs(
            globalRulestackName = globalRulestackName,
        )
        return getGlobalRulestackChangeLogResultToKotlin(getGlobalRulestackChangeLogPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalRulestackChangeLog].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetGlobalRulestackChangeLogPlainArgs].
     * @return Changelog list
     */
    public suspend fun getGlobalRulestackChangeLog(argument: suspend GetGlobalRulestackChangeLogPlainArgsBuilder.() -> Unit): GetGlobalRulestackChangeLogResult {
        val builder = GetGlobalRulestackChangeLogPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalRulestackChangeLogResultToKotlin(getGlobalRulestackChangeLogPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a LocalRulesResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return LocalRulestack rule list
     */
    public suspend fun getLocalRule(argument: GetLocalRulePlainArgs): GetLocalRuleResult =
        getLocalRuleResultToKotlin(getLocalRulePlain(argument.toJava()).await())

    /**
     * @see [getLocalRule].
     * @param localRulestackName LocalRulestack resource name
     * @param priority Local Rule priority
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return LocalRulestack rule list
     */
    public suspend fun getLocalRule(
        localRulestackName: String,
        priority: String,
        resourceGroupName: String,
    ): GetLocalRuleResult {
        val argument = GetLocalRulePlainArgs(
            localRulestackName = localRulestackName,
            priority = priority,
            resourceGroupName = resourceGroupName,
        )
        return getLocalRuleResultToKotlin(getLocalRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetLocalRulePlainArgs].
     * @return LocalRulestack rule list
     */
    public suspend fun getLocalRule(argument: suspend GetLocalRulePlainArgsBuilder.() -> Unit): GetLocalRuleResult {
        val builder = GetLocalRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalRuleResultToKotlin(getLocalRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get counters
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Rule counter
     */
    public suspend fun getLocalRuleCounters(argument: GetLocalRuleCountersPlainArgs): GetLocalRuleCountersResult =
        getLocalRuleCountersResultToKotlin(getLocalRuleCountersPlain(argument.toJava()).await())

    /**
     * @see [getLocalRuleCounters].
     * @param firewallName
     * @param localRulestackName LocalRulestack resource name
     * @param priority Local Rule priority
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Rule counter
     */
    public suspend fun getLocalRuleCounters(
        firewallName: String? = null,
        localRulestackName: String,
        priority: String,
        resourceGroupName: String,
    ): GetLocalRuleCountersResult {
        val argument = GetLocalRuleCountersPlainArgs(
            firewallName = firewallName,
            localRulestackName = localRulestackName,
            priority = priority,
            resourceGroupName = resourceGroupName,
        )
        return getLocalRuleCountersResultToKotlin(getLocalRuleCountersPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalRuleCounters].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetLocalRuleCountersPlainArgs].
     * @return Rule counter
     */
    public suspend fun getLocalRuleCounters(argument: suspend GetLocalRuleCountersPlainArgsBuilder.() -> Unit): GetLocalRuleCountersResult {
        val builder = GetLocalRuleCountersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalRuleCountersResultToKotlin(getLocalRuleCountersPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a LocalRulestackResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return PaloAltoNetworks LocalRulestack
     */
    public suspend fun getLocalRulestack(argument: GetLocalRulestackPlainArgs): GetLocalRulestackResult =
        getLocalRulestackResultToKotlin(getLocalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getLocalRulestack].
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return PaloAltoNetworks LocalRulestack
     */
    public suspend fun getLocalRulestack(localRulestackName: String, resourceGroupName: String): GetLocalRulestackResult {
        val argument = GetLocalRulestackPlainArgs(
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
        )
        return getLocalRulestackResultToKotlin(getLocalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetLocalRulestackPlainArgs].
     * @return PaloAltoNetworks LocalRulestack
     */
    public suspend fun getLocalRulestack(argument: suspend GetLocalRulestackPlainArgsBuilder.() -> Unit): GetLocalRulestackResult {
        val builder = GetLocalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalRulestackResultToKotlin(getLocalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get changelog
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Changelog list
     */
    public suspend fun getLocalRulestackChangeLog(argument: GetLocalRulestackChangeLogPlainArgs): GetLocalRulestackChangeLogResult =
        getLocalRulestackChangeLogResultToKotlin(getLocalRulestackChangeLogPlain(argument.toJava()).await())

    /**
     * @see [getLocalRulestackChangeLog].
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Changelog list
     */
    public suspend fun getLocalRulestackChangeLog(
        localRulestackName: String,
        resourceGroupName: String,
    ): GetLocalRulestackChangeLogResult {
        val argument = GetLocalRulestackChangeLogPlainArgs(
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
        )
        return getLocalRulestackChangeLogResultToKotlin(getLocalRulestackChangeLogPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalRulestackChangeLog].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetLocalRulestackChangeLogPlainArgs].
     * @return Changelog list
     */
    public suspend fun getLocalRulestackChangeLog(argument: suspend GetLocalRulestackChangeLogPlainArgsBuilder.() -> Unit): GetLocalRulestackChangeLogResult {
        val builder = GetLocalRulestackChangeLogPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalRulestackChangeLogResultToKotlin(getLocalRulestackChangeLogPlain(builtArgument.toJava()).await())
    }

    /**
     * support info for rulestack.
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Support information for the resource
     */
    public suspend fun getLocalRulestackSupportInfo(argument: GetLocalRulestackSupportInfoPlainArgs): GetLocalRulestackSupportInfoResult =
        getLocalRulestackSupportInfoResultToKotlin(getLocalRulestackSupportInfoPlain(argument.toJava()).await())

    /**
     * @see [getLocalRulestackSupportInfo].
     * @param email email address on behalf of which this API called
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Support information for the resource
     */
    public suspend fun getLocalRulestackSupportInfo(
        email: String? = null,
        localRulestackName: String,
        resourceGroupName: String,
    ): GetLocalRulestackSupportInfoResult {
        val argument = GetLocalRulestackSupportInfoPlainArgs(
            email = email,
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
        )
        return getLocalRulestackSupportInfoResultToKotlin(getLocalRulestackSupportInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalRulestackSupportInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetLocalRulestackSupportInfoPlainArgs].
     * @return Support information for the resource
     */
    public suspend fun getLocalRulestackSupportInfo(argument: suspend GetLocalRulestackSupportInfoPlainArgsBuilder.() -> Unit): GetLocalRulestackSupportInfoResult {
        val builder = GetLocalRulestackSupportInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalRulestackSupportInfoResultToKotlin(getLocalRulestackSupportInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a PostRulesResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return PostRulestack rule list
     */
    public suspend fun getPostRule(argument: GetPostRulePlainArgs): GetPostRuleResult =
        getPostRuleResultToKotlin(getPostRulePlain(argument.toJava()).await())

    /**
     * @see [getPostRule].
     * @param globalRulestackName GlobalRulestack resource name
     * @param priority Post Rule priority
     * @return PostRulestack rule list
     */
    public suspend fun getPostRule(globalRulestackName: String, priority: String): GetPostRuleResult {
        val argument = GetPostRulePlainArgs(
            globalRulestackName = globalRulestackName,
            priority = priority,
        )
        return getPostRuleResultToKotlin(getPostRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getPostRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetPostRulePlainArgs].
     * @return PostRulestack rule list
     */
    public suspend fun getPostRule(argument: suspend GetPostRulePlainArgsBuilder.() -> Unit): GetPostRuleResult {
        val builder = GetPostRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPostRuleResultToKotlin(getPostRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get counters
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Rule counter
     */
    public suspend fun getPostRuleCounters(argument: GetPostRuleCountersPlainArgs): GetPostRuleCountersResult =
        getPostRuleCountersResultToKotlin(getPostRuleCountersPlain(argument.toJava()).await())

    /**
     * @see [getPostRuleCounters].
     * @param firewallName
     * @param globalRulestackName GlobalRulestack resource name
     * @param priority Post Rule priority
     * @return Rule counter
     */
    public suspend fun getPostRuleCounters(
        firewallName: String? = null,
        globalRulestackName: String,
        priority: String,
    ): GetPostRuleCountersResult {
        val argument = GetPostRuleCountersPlainArgs(
            firewallName = firewallName,
            globalRulestackName = globalRulestackName,
            priority = priority,
        )
        return getPostRuleCountersResultToKotlin(getPostRuleCountersPlain(argument.toJava()).await())
    }

    /**
     * @see [getPostRuleCounters].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetPostRuleCountersPlainArgs].
     * @return Rule counter
     */
    public suspend fun getPostRuleCounters(argument: suspend GetPostRuleCountersPlainArgsBuilder.() -> Unit): GetPostRuleCountersResult {
        val builder = GetPostRuleCountersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPostRuleCountersResultToKotlin(getPostRuleCountersPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a PreRulesResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return PreRulestack rule list
     */
    public suspend fun getPreRule(argument: GetPreRulePlainArgs): GetPreRuleResult =
        getPreRuleResultToKotlin(getPreRulePlain(argument.toJava()).await())

    /**
     * @see [getPreRule].
     * @param globalRulestackName GlobalRulestack resource name
     * @param priority Pre Rule priority
     * @return PreRulestack rule list
     */
    public suspend fun getPreRule(globalRulestackName: String, priority: String): GetPreRuleResult {
        val argument = GetPreRulePlainArgs(
            globalRulestackName = globalRulestackName,
            priority = priority,
        )
        return getPreRuleResultToKotlin(getPreRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getPreRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetPreRulePlainArgs].
     * @return PreRulestack rule list
     */
    public suspend fun getPreRule(argument: suspend GetPreRulePlainArgsBuilder.() -> Unit): GetPreRuleResult {
        val builder = GetPreRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPreRuleResultToKotlin(getPreRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get counters
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Rule counter
     */
    public suspend fun getPreRuleCounters(argument: GetPreRuleCountersPlainArgs): GetPreRuleCountersResult =
        getPreRuleCountersResultToKotlin(getPreRuleCountersPlain(argument.toJava()).await())

    /**
     * @see [getPreRuleCounters].
     * @param firewallName
     * @param globalRulestackName GlobalRulestack resource name
     * @param priority Pre Rule priority
     * @return Rule counter
     */
    public suspend fun getPreRuleCounters(
        firewallName: String? = null,
        globalRulestackName: String,
        priority: String,
    ): GetPreRuleCountersResult {
        val argument = GetPreRuleCountersPlainArgs(
            firewallName = firewallName,
            globalRulestackName = globalRulestackName,
            priority = priority,
        )
        return getPreRuleCountersResultToKotlin(getPreRuleCountersPlain(argument.toJava()).await())
    }

    /**
     * @see [getPreRuleCounters].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetPreRuleCountersPlainArgs].
     * @return Rule counter
     */
    public suspend fun getPreRuleCounters(argument: suspend GetPreRuleCountersPlainArgsBuilder.() -> Unit): GetPreRuleCountersResult {
        val builder = GetPreRuleCountersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPreRuleCountersResultToKotlin(getPreRuleCountersPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a PrefixListGlobalRulestackResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return GlobalRulestack prefixList
     */
    public suspend fun getPrefixListGlobalRulestack(argument: GetPrefixListGlobalRulestackPlainArgs): GetPrefixListGlobalRulestackResult =
        getPrefixListGlobalRulestackResultToKotlin(getPrefixListGlobalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getPrefixListGlobalRulestack].
     * @param globalRulestackName GlobalRulestack resource name
     * @param name Local Rule priority
     * @return GlobalRulestack prefixList
     */
    public suspend fun getPrefixListGlobalRulestack(globalRulestackName: String, name: String): GetPrefixListGlobalRulestackResult {
        val argument = GetPrefixListGlobalRulestackPlainArgs(
            globalRulestackName = globalRulestackName,
            name = name,
        )
        return getPrefixListGlobalRulestackResultToKotlin(getPrefixListGlobalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrefixListGlobalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetPrefixListGlobalRulestackPlainArgs].
     * @return GlobalRulestack prefixList
     */
    public suspend fun getPrefixListGlobalRulestack(argument: suspend GetPrefixListGlobalRulestackPlainArgsBuilder.() -> Unit): GetPrefixListGlobalRulestackResult {
        val builder = GetPrefixListGlobalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrefixListGlobalRulestackResultToKotlin(getPrefixListGlobalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a PrefixListResource
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return LocalRulestack prefixList
     */
    public suspend fun getPrefixListLocalRulestack(argument: GetPrefixListLocalRulestackPlainArgs): GetPrefixListLocalRulestackResult =
        getPrefixListLocalRulestackResultToKotlin(getPrefixListLocalRulestackPlain(argument.toJava()).await())

    /**
     * @see [getPrefixListLocalRulestack].
     * @param localRulestackName LocalRulestack resource name
     * @param name Local Rule priority
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return LocalRulestack prefixList
     */
    public suspend fun getPrefixListLocalRulestack(
        localRulestackName: String,
        name: String,
        resourceGroupName: String,
    ): GetPrefixListLocalRulestackResult {
        val argument = GetPrefixListLocalRulestackPlainArgs(
            localRulestackName = localRulestackName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getPrefixListLocalRulestackResultToKotlin(getPrefixListLocalRulestackPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrefixListLocalRulestack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;GetPrefixListLocalRulestackPlainArgs].
     * @return LocalRulestack prefixList
     */
    public suspend fun getPrefixListLocalRulestack(argument: suspend GetPrefixListLocalRulestackPlainArgsBuilder.() -> Unit): GetPrefixListLocalRulestackResult {
        val builder = GetPrefixListLocalRulestackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrefixListLocalRulestackResultToKotlin(getPrefixListLocalRulestackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the list of advanced security objects
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return advanced security object
     */
    public suspend fun listGlobalRulestackAdvancedSecurityObjects(argument: ListGlobalRulestackAdvancedSecurityObjectsPlainArgs): ListGlobalRulestackAdvancedSecurityObjectsResult =
        listGlobalRulestackAdvancedSecurityObjectsResultToKotlin(listGlobalRulestackAdvancedSecurityObjectsPlain(argument.toJava()).await())

    /**
     * @see [listGlobalRulestackAdvancedSecurityObjects].
     * @param globalRulestackName GlobalRulestack resource name
     * @param skip
     * @param top
     * @param type
     * @return advanced security object
     */
    public suspend fun listGlobalRulestackAdvancedSecurityObjects(
        globalRulestackName: String,
        skip: String? = null,
        top: Int? = null,
        type: String,
    ): ListGlobalRulestackAdvancedSecurityObjectsResult {
        val argument = ListGlobalRulestackAdvancedSecurityObjectsPlainArgs(
            globalRulestackName = globalRulestackName,
            skip = skip,
            top = top,
            type = type,
        )
        return listGlobalRulestackAdvancedSecurityObjectsResultToKotlin(listGlobalRulestackAdvancedSecurityObjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalRulestackAdvancedSecurityObjects].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListGlobalRulestackAdvancedSecurityObjectsPlainArgs].
     * @return advanced security object
     */
    public suspend fun listGlobalRulestackAdvancedSecurityObjects(argument: suspend ListGlobalRulestackAdvancedSecurityObjectsPlainArgsBuilder.() -> Unit): ListGlobalRulestackAdvancedSecurityObjectsResult {
        val builder = ListGlobalRulestackAdvancedSecurityObjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalRulestackAdvancedSecurityObjectsResultToKotlin(listGlobalRulestackAdvancedSecurityObjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * List of AppIds for GlobalRulestack ApiVersion
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return null
     */
    public suspend fun listGlobalRulestackAppIds(argument: ListGlobalRulestackAppIdsPlainArgs): ListGlobalRulestackAppIdsResult =
        listGlobalRulestackAppIdsResultToKotlin(listGlobalRulestackAppIdsPlain(argument.toJava()).await())

    /**
     * @see [listGlobalRulestackAppIds].
     * @param appIdVersion
     * @param appPrefix
     * @param globalRulestackName GlobalRulestack resource name
     * @param skip
     * @param top
     * @return null
     */
    public suspend fun listGlobalRulestackAppIds(
        appIdVersion: String? = null,
        appPrefix: String? = null,
        globalRulestackName: String,
        skip: String? = null,
        top: Int? = null,
    ): ListGlobalRulestackAppIdsResult {
        val argument = ListGlobalRulestackAppIdsPlainArgs(
            appIdVersion = appIdVersion,
            appPrefix = appPrefix,
            globalRulestackName = globalRulestackName,
            skip = skip,
            top = top,
        )
        return listGlobalRulestackAppIdsResultToKotlin(listGlobalRulestackAppIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalRulestackAppIds].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListGlobalRulestackAppIdsPlainArgs].
     * @return null
     */
    public suspend fun listGlobalRulestackAppIds(argument: suspend ListGlobalRulestackAppIdsPlainArgsBuilder.() -> Unit): ListGlobalRulestackAppIdsResult {
        val builder = ListGlobalRulestackAppIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalRulestackAppIdsResultToKotlin(listGlobalRulestackAppIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * List of countries for Rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Countries Response Object
     */
    public suspend fun listGlobalRulestackCountries(argument: ListGlobalRulestackCountriesPlainArgs): ListGlobalRulestackCountriesResult =
        listGlobalRulestackCountriesResultToKotlin(listGlobalRulestackCountriesPlain(argument.toJava()).await())

    /**
     * @see [listGlobalRulestackCountries].
     * @param globalRulestackName GlobalRulestack resource name
     * @param skip
     * @param top
     * @return Countries Response Object
     */
    public suspend fun listGlobalRulestackCountries(
        globalRulestackName: String,
        skip: String? = null,
        top: Int? = null,
    ): ListGlobalRulestackCountriesResult {
        val argument = ListGlobalRulestackCountriesPlainArgs(
            globalRulestackName = globalRulestackName,
            skip = skip,
            top = top,
        )
        return listGlobalRulestackCountriesResultToKotlin(listGlobalRulestackCountriesPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalRulestackCountries].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListGlobalRulestackCountriesPlainArgs].
     * @return Countries Response Object
     */
    public suspend fun listGlobalRulestackCountries(argument: suspend ListGlobalRulestackCountriesPlainArgsBuilder.() -> Unit): ListGlobalRulestackCountriesResult {
        val builder = ListGlobalRulestackCountriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalRulestackCountriesResultToKotlin(listGlobalRulestackCountriesPlain(builtArgument.toJava()).await())
    }

    /**
     * List of Firewalls associated with Rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return List firewalls response
     */
    public suspend fun listGlobalRulestackFirewalls(argument: ListGlobalRulestackFirewallsPlainArgs): ListGlobalRulestackFirewallsResult =
        listGlobalRulestackFirewallsResultToKotlin(listGlobalRulestackFirewallsPlain(argument.toJava()).await())

    /**
     * @see [listGlobalRulestackFirewalls].
     * @param globalRulestackName GlobalRulestack resource name
     * @return List firewalls response
     */
    public suspend fun listGlobalRulestackFirewalls(globalRulestackName: String): ListGlobalRulestackFirewallsResult {
        val argument = ListGlobalRulestackFirewallsPlainArgs(
            globalRulestackName = globalRulestackName,
        )
        return listGlobalRulestackFirewallsResultToKotlin(listGlobalRulestackFirewallsPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalRulestackFirewalls].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListGlobalRulestackFirewallsPlainArgs].
     * @return List firewalls response
     */
    public suspend fun listGlobalRulestackFirewalls(argument: suspend ListGlobalRulestackFirewallsPlainArgsBuilder.() -> Unit): ListGlobalRulestackFirewallsResult {
        val builder = ListGlobalRulestackFirewallsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalRulestackFirewallsResultToKotlin(listGlobalRulestackFirewallsPlain(builtArgument.toJava()).await())
    }

    /**
     * List predefined URL categories for rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return predefined url categories response
     */
    public suspend fun listGlobalRulestackPredefinedUrlCategories(argument: ListGlobalRulestackPredefinedUrlCategoriesPlainArgs): ListGlobalRulestackPredefinedUrlCategoriesResult =
        listGlobalRulestackPredefinedUrlCategoriesResultToKotlin(listGlobalRulestackPredefinedUrlCategoriesPlain(argument.toJava()).await())

    /**
     * @see [listGlobalRulestackPredefinedUrlCategories].
     * @param globalRulestackName GlobalRulestack resource name
     * @param skip
     * @param top
     * @return predefined url categories response
     */
    public suspend fun listGlobalRulestackPredefinedUrlCategories(
        globalRulestackName: String,
        skip: String? = null,
        top: Int? = null,
    ): ListGlobalRulestackPredefinedUrlCategoriesResult {
        val argument = ListGlobalRulestackPredefinedUrlCategoriesPlainArgs(
            globalRulestackName = globalRulestackName,
            skip = skip,
            top = top,
        )
        return listGlobalRulestackPredefinedUrlCategoriesResultToKotlin(listGlobalRulestackPredefinedUrlCategoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalRulestackPredefinedUrlCategories].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListGlobalRulestackPredefinedUrlCategoriesPlainArgs].
     * @return predefined url categories response
     */
    public suspend fun listGlobalRulestackPredefinedUrlCategories(argument: suspend ListGlobalRulestackPredefinedUrlCategoriesPlainArgsBuilder.() -> Unit): ListGlobalRulestackPredefinedUrlCategoriesResult {
        val builder = ListGlobalRulestackPredefinedUrlCategoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalRulestackPredefinedUrlCategoriesResultToKotlin(listGlobalRulestackPredefinedUrlCategoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * List the security services for rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Security services list response
     */
    public suspend fun listGlobalRulestackSecurityServices(argument: ListGlobalRulestackSecurityServicesPlainArgs): ListGlobalRulestackSecurityServicesResult =
        listGlobalRulestackSecurityServicesResultToKotlin(listGlobalRulestackSecurityServicesPlain(argument.toJava()).await())

    /**
     * @see [listGlobalRulestackSecurityServices].
     * @param globalRulestackName GlobalRulestack resource name
     * @param skip
     * @param top
     * @param type
     * @return Security services list response
     */
    public suspend fun listGlobalRulestackSecurityServices(
        globalRulestackName: String,
        skip: String? = null,
        top: Int? = null,
        type: String,
    ): ListGlobalRulestackSecurityServicesResult {
        val argument = ListGlobalRulestackSecurityServicesPlainArgs(
            globalRulestackName = globalRulestackName,
            skip = skip,
            top = top,
            type = type,
        )
        return listGlobalRulestackSecurityServicesResultToKotlin(listGlobalRulestackSecurityServicesPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalRulestackSecurityServices].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListGlobalRulestackSecurityServicesPlainArgs].
     * @return Security services list response
     */
    public suspend fun listGlobalRulestackSecurityServices(argument: suspend ListGlobalRulestackSecurityServicesPlainArgsBuilder.() -> Unit): ListGlobalRulestackSecurityServicesResult {
        val builder = ListGlobalRulestackSecurityServicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalRulestackSecurityServicesResultToKotlin(listGlobalRulestackSecurityServicesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the list of advanced security objects
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return advanced security object
     */
    public suspend fun listLocalRulestackAdvancedSecurityObjects(argument: ListLocalRulestackAdvancedSecurityObjectsPlainArgs): ListLocalRulestackAdvancedSecurityObjectsResult =
        listLocalRulestackAdvancedSecurityObjectsResultToKotlin(listLocalRulestackAdvancedSecurityObjectsPlain(argument.toJava()).await())

    /**
     * @see [listLocalRulestackAdvancedSecurityObjects].
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param skip
     * @param top
     * @param type
     * @return advanced security object
     */
    public suspend fun listLocalRulestackAdvancedSecurityObjects(
        localRulestackName: String,
        resourceGroupName: String,
        skip: String? = null,
        top: Int? = null,
        type: String,
    ): ListLocalRulestackAdvancedSecurityObjectsResult {
        val argument = ListLocalRulestackAdvancedSecurityObjectsPlainArgs(
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
            skip = skip,
            top = top,
            type = type,
        )
        return listLocalRulestackAdvancedSecurityObjectsResultToKotlin(listLocalRulestackAdvancedSecurityObjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocalRulestackAdvancedSecurityObjects].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListLocalRulestackAdvancedSecurityObjectsPlainArgs].
     * @return advanced security object
     */
    public suspend fun listLocalRulestackAdvancedSecurityObjects(argument: suspend ListLocalRulestackAdvancedSecurityObjectsPlainArgsBuilder.() -> Unit): ListLocalRulestackAdvancedSecurityObjectsResult {
        val builder = ListLocalRulestackAdvancedSecurityObjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocalRulestackAdvancedSecurityObjectsResultToKotlin(listLocalRulestackAdvancedSecurityObjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * List of AppIds for LocalRulestack ApiVersion
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return null
     */
    public suspend fun listLocalRulestackAppIds(argument: ListLocalRulestackAppIdsPlainArgs): ListLocalRulestackAppIdsResult =
        listLocalRulestackAppIdsResultToKotlin(listLocalRulestackAppIdsPlain(argument.toJava()).await())

    /**
     * @see [listLocalRulestackAppIds].
     * @param appIdVersion
     * @param appPrefix
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param skip
     * @param top
     * @return null
     */
    public suspend fun listLocalRulestackAppIds(
        appIdVersion: String? = null,
        appPrefix: String? = null,
        localRulestackName: String,
        resourceGroupName: String,
        skip: String? = null,
        top: Int? = null,
    ): ListLocalRulestackAppIdsResult {
        val argument = ListLocalRulestackAppIdsPlainArgs(
            appIdVersion = appIdVersion,
            appPrefix = appPrefix,
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
            skip = skip,
            top = top,
        )
        return listLocalRulestackAppIdsResultToKotlin(listLocalRulestackAppIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocalRulestackAppIds].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListLocalRulestackAppIdsPlainArgs].
     * @return null
     */
    public suspend fun listLocalRulestackAppIds(argument: suspend ListLocalRulestackAppIdsPlainArgsBuilder.() -> Unit): ListLocalRulestackAppIdsResult {
        val builder = ListLocalRulestackAppIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocalRulestackAppIdsResultToKotlin(listLocalRulestackAppIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * List of countries for Rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Countries Response Object
     */
    public suspend fun listLocalRulestackCountries(argument: ListLocalRulestackCountriesPlainArgs): ListLocalRulestackCountriesResult =
        listLocalRulestackCountriesResultToKotlin(listLocalRulestackCountriesPlain(argument.toJava()).await())

    /**
     * @see [listLocalRulestackCountries].
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param skip
     * @param top
     * @return Countries Response Object
     */
    public suspend fun listLocalRulestackCountries(
        localRulestackName: String,
        resourceGroupName: String,
        skip: String? = null,
        top: Int? = null,
    ): ListLocalRulestackCountriesResult {
        val argument = ListLocalRulestackCountriesPlainArgs(
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
            skip = skip,
            top = top,
        )
        return listLocalRulestackCountriesResultToKotlin(listLocalRulestackCountriesPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocalRulestackCountries].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListLocalRulestackCountriesPlainArgs].
     * @return Countries Response Object
     */
    public suspend fun listLocalRulestackCountries(argument: suspend ListLocalRulestackCountriesPlainArgsBuilder.() -> Unit): ListLocalRulestackCountriesResult {
        val builder = ListLocalRulestackCountriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocalRulestackCountriesResultToKotlin(listLocalRulestackCountriesPlain(builtArgument.toJava()).await())
    }

    /**
     * List of Firewalls associated with Rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return List firewalls response
     */
    public suspend fun listLocalRulestackFirewalls(argument: ListLocalRulestackFirewallsPlainArgs): ListLocalRulestackFirewallsResult =
        listLocalRulestackFirewallsResultToKotlin(listLocalRulestackFirewallsPlain(argument.toJava()).await())

    /**
     * @see [listLocalRulestackFirewalls].
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return List firewalls response
     */
    public suspend fun listLocalRulestackFirewalls(
        localRulestackName: String,
        resourceGroupName: String,
    ): ListLocalRulestackFirewallsResult {
        val argument = ListLocalRulestackFirewallsPlainArgs(
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
        )
        return listLocalRulestackFirewallsResultToKotlin(listLocalRulestackFirewallsPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocalRulestackFirewalls].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListLocalRulestackFirewallsPlainArgs].
     * @return List firewalls response
     */
    public suspend fun listLocalRulestackFirewalls(argument: suspend ListLocalRulestackFirewallsPlainArgsBuilder.() -> Unit): ListLocalRulestackFirewallsResult {
        val builder = ListLocalRulestackFirewallsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocalRulestackFirewallsResultToKotlin(listLocalRulestackFirewallsPlain(builtArgument.toJava()).await())
    }

    /**
     * List predefined URL categories for rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return predefined url categories response
     */
    public suspend fun listLocalRulestackPredefinedUrlCategories(argument: ListLocalRulestackPredefinedUrlCategoriesPlainArgs): ListLocalRulestackPredefinedUrlCategoriesResult =
        listLocalRulestackPredefinedUrlCategoriesResultToKotlin(listLocalRulestackPredefinedUrlCategoriesPlain(argument.toJava()).await())

    /**
     * @see [listLocalRulestackPredefinedUrlCategories].
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param skip
     * @param top
     * @return predefined url categories response
     */
    public suspend fun listLocalRulestackPredefinedUrlCategories(
        localRulestackName: String,
        resourceGroupName: String,
        skip: String? = null,
        top: Int? = null,
    ): ListLocalRulestackPredefinedUrlCategoriesResult {
        val argument = ListLocalRulestackPredefinedUrlCategoriesPlainArgs(
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
            skip = skip,
            top = top,
        )
        return listLocalRulestackPredefinedUrlCategoriesResultToKotlin(listLocalRulestackPredefinedUrlCategoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocalRulestackPredefinedUrlCategories].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListLocalRulestackPredefinedUrlCategoriesPlainArgs].
     * @return predefined url categories response
     */
    public suspend fun listLocalRulestackPredefinedUrlCategories(argument: suspend ListLocalRulestackPredefinedUrlCategoriesPlainArgsBuilder.() -> Unit): ListLocalRulestackPredefinedUrlCategoriesResult {
        val builder = ListLocalRulestackPredefinedUrlCategoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocalRulestackPredefinedUrlCategoriesResultToKotlin(listLocalRulestackPredefinedUrlCategoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * List the security services for rulestack
     * Azure REST API version: 2023-09-01.
     * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
     * @param argument null
     * @return Security services list response
     */
    public suspend fun listLocalRulestackSecurityServices(argument: ListLocalRulestackSecurityServicesPlainArgs): ListLocalRulestackSecurityServicesResult =
        listLocalRulestackSecurityServicesResultToKotlin(listLocalRulestackSecurityServicesPlain(argument.toJava()).await())

    /**
     * @see [listLocalRulestackSecurityServices].
     * @param localRulestackName LocalRulestack resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param skip
     * @param top
     * @param type
     * @return Security services list response
     */
    public suspend fun listLocalRulestackSecurityServices(
        localRulestackName: String,
        resourceGroupName: String,
        skip: String? = null,
        top: Int? = null,
        type: String,
    ): ListLocalRulestackSecurityServicesResult {
        val argument = ListLocalRulestackSecurityServicesPlainArgs(
            localRulestackName = localRulestackName,
            resourceGroupName = resourceGroupName,
            skip = skip,
            top = top,
            type = type,
        )
        return listLocalRulestackSecurityServicesResultToKotlin(listLocalRulestackSecurityServicesPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocalRulestackSecurityServices].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;cloudngfw&#46;kotlin&#46;inputs&#46;ListLocalRulestackSecurityServicesPlainArgs].
     * @return Security services list response
     */
    public suspend fun listLocalRulestackSecurityServices(argument: suspend ListLocalRulestackSecurityServicesPlainArgsBuilder.() -> Unit): ListLocalRulestackSecurityServicesResult {
        val builder = ListLocalRulestackSecurityServicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocalRulestackSecurityServicesResultToKotlin(listLocalRulestackSecurityServicesPlain(builtArgument.toJava()).await())
    }

    /**
     * Cloud Manager Tenant
     * Azure REST API version: 2024-02-07-preview.
     * @param argument null
     * @return Cloud Manager Tenant
     */
    public suspend fun listPaloAltoNetworksCloudngfwCloudManagerTenants(): ListPaloAltoNetworksCloudngfwCloudManagerTenantsResult =
        listPaloAltoNetworksCloudngfwCloudManagerTenantsResultToKotlin(listPaloAltoNetworksCloudngfwCloudManagerTenantsPlain().await())

    /**
     * Product serial and status for the service
     * Azure REST API version: 2024-02-07-preview.
     * @param argument null
     * @return Product serial and status for the service
     */
    public suspend fun listPaloAltoNetworksCloudngfwProductSerialNumberStatus(): ListPaloAltoNetworksCloudngfwProductSerialNumberStatusResult =
        listPaloAltoNetworksCloudngfwProductSerialNumberStatusResultToKotlin(listPaloAltoNetworksCloudngfwProductSerialNumberStatusPlain().await())

    /**
     * Support information for the service
     * Azure REST API version: 2024-02-07-preview.
     * Other available API versions: 2024-01-19-preview.
     * @param argument null
     * @return Support information for the service
     */
    public suspend fun listPaloAltoNetworksCloudngfwSupportInfo(): ListPaloAltoNetworksCloudngfwSupportInfoResult =
        listPaloAltoNetworksCloudngfwSupportInfoResultToKotlin(listPaloAltoNetworksCloudngfwSupportInfoPlain().await())
}
