@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.kotlin.outputs.AzureResourceManagerManagedIdentityPropertiesResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.DNSSettingsResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.FrontendSettingResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.MarketplaceDetailsResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.PanoramaConfigResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.PlanDataResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.RulestackDetailsResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.AzureResourceManagerManagedIdentityPropertiesResponse.Companion.toKotlin as azureResourceManagerManagedIdentityPropertiesResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.DNSSettingsResponse.Companion.toKotlin as dNSSettingsResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.FrontendSettingResponse.Companion.toKotlin as frontendSettingResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.MarketplaceDetailsResponse.Companion.toKotlin as marketplaceDetailsResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.PanoramaConfigResponse.Companion.toKotlin as panoramaConfigResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.PlanDataResponse.Companion.toKotlin as planDataResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.RulestackDetailsResponse.Companion.toKotlin as rulestackDetailsResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Firewall].
 */
@PulumiTagMarker
public class FirewallResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallArgs = FirewallArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallArgsBuilder.() -> Unit) {
        val builder = FirewallArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Firewall {
        val builtJavaResource = com.pulumi.azurenative.cloudngfw.Firewall(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Firewall(builtJavaResource)
    }
}

/**
 * PaloAltoNetworks Firewall
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### Firewalls_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewall = new AzureNative.Cloudngfw.Firewall("firewall", new()
 *     {
 *         AssociatedRulestack = new AzureNative.Cloudngfw.Inputs.RulestackDetailsArgs
 *         {
 *             Location = "eastus",
 *             ResourceId = "lrs1",
 *             RulestackId = "PANRSID",
 *         },
 *         DnsSettings = new AzureNative.Cloudngfw.Inputs.DNSSettingsArgs
 *         {
 *             DnsServers = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.111",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1",
 *                 },
 *             },
 *             EnableDnsProxy = AzureNative.Cloudngfw.DNSProxy.DISABLED,
 *             EnabledDnsType = AzureNative.Cloudngfw.EnabledDNSType.CUSTOM,
 *         },
 *         FirewallName = "firewall1",
 *         FrontEndSettings = new[]
 *         {
 *             new AzureNative.Cloudngfw.Inputs.FrontendSettingArgs
 *             {
 *                 BackendConfiguration = new AzureNative.Cloudngfw.Inputs.EndpointConfigurationArgs
 *                 {
 *                     Address = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                     {
 *                         Address = "20.22.32.136",
 *                         ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2",
 *                     },
 *                     Port = "80",
 *                 },
 *                 FrontendConfiguration = new AzureNative.Cloudngfw.Inputs.EndpointConfigurationArgs
 *                 {
 *                     Address = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                     {
 *                         Address = "20.22.91.251",
 *                         ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1",
 *                     },
 *                     Port = "80",
 *                 },
 *                 Name = "frontendsetting11",
 *                 Protocol = AzureNative.Cloudngfw.ProtocolType.TCP,
 *             },
 *         },
 *         Identity = new AzureNative.Cloudngfw.Inputs.AzureResourceManagerManagedIdentityPropertiesArgs
 *         {
 *             Type = AzureNative.Cloudngfw.ManagedIdentityType.None,
 *             UserAssignedIdentities =
 *             {
 *                 { "key16", new AzureNative.Cloudngfw.Inputs.AzureResourceManagerUserAssignedIdentityArgs
 *                 {
 *                     ClientId = "aaaa",
 *                     PrincipalId = "aaaaaaaaaaaaaaa",
 *                 } },
 *             },
 *         },
 *         IsPanoramaManaged = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         Location = "eastus",
 *         MarketplaceDetails = new AzureNative.Cloudngfw.Inputs.MarketplaceDetailsArgs
 *         {
 *             MarketplaceSubscriptionStatus = AzureNative.Cloudngfw.MarketplaceSubscriptionStatus.PendingFulfillmentStart,
 *             OfferId = "liftr-pan-ame-test",
 *             PublisherId = "isvtestuklegacy",
 *         },
 *         NetworkProfile = new AzureNative.Cloudngfw.Inputs.NetworkProfileArgs
 *         {
 *             EgressNatIp = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.111",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1",
 *                 },
 *             },
 *             EnableEgressNat = AzureNative.Cloudngfw.EgressNat.ENABLED,
 *             NetworkType = AzureNative.Cloudngfw.NetworkType.VNET,
 *             PublicIps = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.11",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1",
 *                 },
 *             },
 *             TrustedRanges = new[]
 *             {
 *                 "20.22.92.11",
 *             },
 *             VnetConfiguration = new AzureNative.Cloudngfw.Inputs.VnetConfigurationArgs
 *             {
 *                 IpOfTrustSubnetForUdr = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 TrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet",
 *                 },
 *                 UnTrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 Vnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.0.0/16",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet",
 *                 },
 *             },
 *             VwanConfiguration = new AzureNative.Cloudngfw.Inputs.VwanConfigurationArgs
 *             {
 *                 IpOfTrustSubnetForUdr = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 NetworkVirtualApplianceId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
 *                 TrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet",
 *                 },
 *                 UnTrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 VHub = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *             },
 *         },
 *         PanEtag = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
 *         PanoramaConfig = new AzureNative.Cloudngfw.Inputs.PanoramaConfigArgs
 *         {
 *             ConfigString = "bas64EncodedString",
 *         },
 *         PlanData = new AzureNative.Cloudngfw.Inputs.PlanDataArgs
 *         {
 *             BillingCycle = AzureNative.Cloudngfw.BillingCycle.MONTHLY,
 *             PlanId = "liftrpantestplan",
 *             UsageType = AzureNative.Cloudngfw.UsageType.PAYG,
 *         },
 *         ResourceGroupName = "firewall-rg",
 *         Tags =
 *         {
 *             { "tagName", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFirewall(ctx, "firewall", &cloudngfw.FirewallArgs{
 * 			AssociatedRulestack: &cloudngfw.RulestackDetailsArgs{
 * 				Location:    pulumi.String("eastus"),
 * 				ResourceId:  pulumi.String("lrs1"),
 * 				RulestackId: pulumi.String("PANRSID"),
 * 			},
 * 			DnsSettings: &cloudngfw.DNSSettingsArgs{
 * 				DnsServers: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.111"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
 * 					},
 * 				},
 * 				EnableDnsProxy: pulumi.String(cloudngfw.DNSProxyDISABLED),
 * 				EnabledDnsType: pulumi.String(cloudngfw.EnabledDNSTypeCUSTOM),
 * 			},
 * 			FirewallName: pulumi.String("firewall1"),
 * 			FrontEndSettings: cloudngfw.FrontendSettingArray{
 * 				&cloudngfw.FrontendSettingArgs{
 * 					BackendConfiguration: &cloudngfw.EndpointConfigurationArgs{
 * 						Address: &cloudngfw.IPAddressArgs{
 * 							Address:    pulumi.String("20.22.32.136"),
 * 							ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
 * 						},
 * 						Port: pulumi.String("80"),
 * 					},
 * 					FrontendConfiguration: &cloudngfw.EndpointConfigurationArgs{
 * 						Address: &cloudngfw.IPAddressArgs{
 * 							Address:    pulumi.String("20.22.91.251"),
 * 							ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
 * 						},
 * 						Port: pulumi.String("80"),
 * 					},
 * 					Name:     pulumi.String("frontendsetting11"),
 * 					Protocol: pulumi.String(cloudngfw.ProtocolTypeTCP),
 * 				},
 * 			},
 * 			Identity: &cloudngfw.AzureResourceManagerManagedIdentityPropertiesArgs{
 * 				Type: pulumi.String(cloudngfw.ManagedIdentityTypeNone),
 * 				UserAssignedIdentities: cloudngfw.AzureResourceManagerUserAssignedIdentityMap{
 * 					"key16": &cloudngfw.AzureResourceManagerUserAssignedIdentityArgs{
 * 						ClientId:    pulumi.String("aaaa"),
 * 						PrincipalId: pulumi.String("aaaaaaaaaaaaaaa"),
 * 					},
 * 				},
 * 			},
 * 			IsPanoramaManaged: pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			Location:          pulumi.String("eastus"),
 * 			MarketplaceDetails: &cloudngfw.MarketplaceDetailsArgs{
 * 				MarketplaceSubscriptionStatus: pulumi.String(cloudngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
 * 				OfferId:                       pulumi.String("liftr-pan-ame-test"),
 * 				PublisherId:                   pulumi.String("isvtestuklegacy"),
 * 			},
 * 			NetworkProfile: &cloudngfw.NetworkProfileArgs{
 * 				EgressNatIp: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.111"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
 * 					},
 * 				},
 * 				EnableEgressNat: pulumi.String(cloudngfw.EgressNatENABLED),
 * 				NetworkType:     pulumi.String(cloudngfw.NetworkTypeVNET),
 * 				PublicIps: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.11"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
 * 					},
 * 				},
 * 				TrustedRanges: pulumi.StringArray{
 * 					pulumi.String("20.22.92.11"),
 * 				},
 * 				VnetConfiguration: &cloudngfw.VnetConfigurationArgs{
 * 					IpOfTrustSubnetForUdr: &cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("10.1.1.0/24"),
 * 						ResourceId: pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					TrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
 * 					},
 * 					UnTrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					Vnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.0.0/16"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
 * 					},
 * 				},
 * 				VwanConfiguration: &cloudngfw.VwanConfigurationArgs{
 * 					IpOfTrustSubnetForUdr: &cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("10.1.1.0/24"),
 * 						ResourceId: pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					NetworkVirtualApplianceId: pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
 * 					TrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
 * 					},
 * 					UnTrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					VHub: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 				},
 * 			},
 * 			PanEtag: pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
 * 			PanoramaConfig: &cloudngfw.PanoramaConfigArgs{
 * 				ConfigString: pulumi.String("bas64EncodedString"),
 * 			},
 * 			PlanData: &cloudngfw.PlanDataArgs{
 * 				BillingCycle: pulumi.String(cloudngfw.BillingCycleMONTHLY),
 * 				PlanId:       pulumi.String("liftrpantestplan"),
 * 				UsageType:    pulumi.String(cloudngfw.UsageTypePAYG),
 * 			},
 * 			ResourceGroupName: pulumi.String("firewall-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.Firewall;
 * import com.pulumi.azurenative.cloudngfw.FirewallArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.RulestackDetailsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.FrontendSettingArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.EndpointConfigurationArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.IPAddressArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.VnetConfigurationArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.IPAddressSpaceArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.VwanConfigurationArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.PanoramaConfigArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewall = new Firewall("firewall", FirewallArgs.builder()
 *             .associatedRulestack(RulestackDetailsArgs.builder()
 *                 .location("eastus")
 *                 .resourceId("lrs1")
 *                 .rulestackId("PANRSID")
 *                 .build())
 *             .dnsSettings(DNSSettingsArgs.builder()
 *                 .dnsServers(IPAddressArgs.builder()
 *                     .address("20.22.92.111")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1")
 *                     .build())
 *                 .enableDnsProxy("DISABLED")
 *                 .enabledDnsType("CUSTOM")
 *                 .build())
 *             .firewallName("firewall1")
 *             .frontEndSettings(FrontendSettingArgs.builder()
 *                 .backendConfiguration(EndpointConfigurationArgs.builder()
 *                     .address(IPAddressArgs.builder()
 *                         .address("20.22.32.136")
 *                         .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2")
 *                         .build())
 *                     .port("80")
 *                     .build())
 *                 .frontendConfiguration(EndpointConfigurationArgs.builder()
 *                     .address(IPAddressArgs.builder()
 *                         .address("20.22.91.251")
 *                         .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1")
 *                         .build())
 *                     .port("80")
 *                     .build())
 *                 .name("frontendsetting11")
 *                 .protocol("TCP")
 *                 .build())
 *             .identity(AzureResourceManagerManagedIdentityPropertiesArgs.builder()
 *                 .type("None")
 *                 .userAssignedIdentities(Map.of("key16", Map.ofEntries(
 *                     Map.entry("clientId", "aaaa"),
 *                     Map.entry("principalId", "aaaaaaaaaaaaaaa")
 *                 )))
 *                 .build())
 *             .isPanoramaManaged("TRUE")
 *             .location("eastus")
 *             .marketplaceDetails(MarketplaceDetailsArgs.builder()
 *                 .marketplaceSubscriptionStatus("PendingFulfillmentStart")
 *                 .offerId("liftr-pan-ame-test")
 *                 .publisherId("isvtestuklegacy")
 *                 .build())
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .egressNatIp(IPAddressArgs.builder()
 *                     .address("20.22.92.111")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1")
 *                     .build())
 *                 .enableEgressNat("ENABLED")
 *                 .networkType("VNET")
 *                 .publicIps(IPAddressArgs.builder()
 *                     .address("20.22.92.11")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1")
 *                     .build())
 *                 .trustedRanges("20.22.92.11")
 *                 .vnetConfiguration(VnetConfigurationArgs.builder()
 *                     .ipOfTrustSubnetForUdr(IPAddressArgs.builder()
 *                         .address("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .trustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet")
 *                         .build())
 *                     .unTrustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .vnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.0.0/16")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet")
 *                         .build())
 *                     .build())
 *                 .vwanConfiguration(VwanConfigurationArgs.builder()
 *                     .ipOfTrustSubnetForUdr(IPAddressArgs.builder()
 *                         .address("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .networkVirtualApplianceId("2bf4a339-294d-4c25-b0b2-ef649e9f5c12")
 *                     .trustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet")
 *                         .build())
 *                     .unTrustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .vHub(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .panEtag("2bf4a339-294d-4c25-b0b2-ef649e9f5c12")
 *             .panoramaConfig(PanoramaConfigArgs.builder()
 *                 .configString("bas64EncodedString")
 *                 .build())
 *             .planData(PlanDataArgs.builder()
 *                 .billingCycle("MONTHLY")
 *                 .planId("liftrpantestplan")
 *                 .usageType("PAYG")
 *                 .build())
 *             .resourceGroupName("firewall-rg")
 *             .tags(Map.of("tagName", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### Firewalls_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewall = new AzureNative.Cloudngfw.Firewall("firewall", new()
 *     {
 *         DnsSettings = null,
 *         FirewallName = "firewall1",
 *         Location = "eastus",
 *         MarketplaceDetails = new AzureNative.Cloudngfw.Inputs.MarketplaceDetailsArgs
 *         {
 *             OfferId = "liftr-pan-ame-test",
 *             PublisherId = "isvtestuklegacy",
 *         },
 *         NetworkProfile = new AzureNative.Cloudngfw.Inputs.NetworkProfileArgs
 *         {
 *             EnableEgressNat = AzureNative.Cloudngfw.EgressNat.ENABLED,
 *             NetworkType = AzureNative.Cloudngfw.NetworkType.VNET,
 *             PublicIps = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.11",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1",
 *                 },
 *             },
 *         },
 *         PlanData = new AzureNative.Cloudngfw.Inputs.PlanDataArgs
 *         {
 *             BillingCycle = AzureNative.Cloudngfw.BillingCycle.MONTHLY,
 *             PlanId = "liftrpantestplan",
 *         },
 *         ResourceGroupName = "firewall-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFirewall(ctx, "firewall", &cloudngfw.FirewallArgs{
 * 			DnsSettings:  nil,
 * 			FirewallName: pulumi.String("firewall1"),
 * 			Location:     pulumi.String("eastus"),
 * 			MarketplaceDetails: &cloudngfw.MarketplaceDetailsArgs{
 * 				OfferId:     pulumi.String("liftr-pan-ame-test"),
 * 				PublisherId: pulumi.String("isvtestuklegacy"),
 * 			},
 * 			NetworkProfile: &cloudngfw.NetworkProfileArgs{
 * 				EnableEgressNat: pulumi.String(cloudngfw.EgressNatENABLED),
 * 				NetworkType:     pulumi.String(cloudngfw.NetworkTypeVNET),
 * 				PublicIps: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.11"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
 * 					},
 * 				},
 * 			},
 * 			PlanData: &cloudngfw.PlanDataArgs{
 * 				BillingCycle: pulumi.String(cloudngfw.BillingCycleMONTHLY),
 * 				PlanId:       pulumi.String("liftrpantestplan"),
 * 			},
 * 			ResourceGroupName: pulumi.String("firewall-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.Firewall;
 * import com.pulumi.azurenative.cloudngfw.FirewallArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewall = new Firewall("firewall", FirewallArgs.builder()
 *             .dnsSettings()
 *             .firewallName("firewall1")
 *             .location("eastus")
 *             .marketplaceDetails(MarketplaceDetailsArgs.builder()
 *                 .offerId("liftr-pan-ame-test")
 *                 .publisherId("isvtestuklegacy")
 *                 .build())
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .enableEgressNat("ENABLED")
 *                 .networkType("VNET")
 *                 .publicIps(IPAddressArgs.builder()
 *                     .address("20.22.92.11")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1")
 *                     .build())
 *                 .build())
 *             .planData(PlanDataArgs.builder()
 *                 .billingCycle("MONTHLY")
 *                 .planId("liftrpantestplan")
 *                 .build())
 *             .resourceGroupName("firewall-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:Firewall armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/firewalls/{firewallName}
 * ```
 */
public class Firewall internal constructor(
    override val javaResource: com.pulumi.azurenative.cloudngfw.Firewall,
) : KotlinCustomResource(javaResource, FirewallMapper) {
    /**
     * Associated Rulestack
     */
    public val associatedRulestack: Output<RulestackDetailsResponse>?
        get() = javaResource.associatedRulestack().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> rulestackDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * DNS settings for Firewall
     */
    public val dnsSettings: Output<DNSSettingsResponse>
        get() = javaResource.dnsSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                dNSSettingsResponseToKotlin(args0)
            })
        })

    /**
     * Frontend settings for Firewall
     */
    public val frontEndSettings: Output<List<FrontendSettingResponse>>?
        get() = javaResource.frontEndSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        frontendSettingResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<AzureResourceManagerManagedIdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    azureResourceManagerManagedIdentityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Panorama Managed: Default is False. Default will be CloudSec managed
     */
    public val isPanoramaManaged: Output<String>?
        get() = javaResource.isPanoramaManaged().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Marketplace details
     */
    public val marketplaceDetails: Output<MarketplaceDetailsResponse>
        get() = javaResource.marketplaceDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                marketplaceDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network settings
     */
    public val networkProfile: Output<NetworkProfileResponse>
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                networkProfileResponseToKotlin(args0)
            })
        })

    /**
     * panEtag info
     */
    public val panEtag: Output<String>?
        get() = javaResource.panEtag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Panorama Configuration
     */
    public val panoramaConfig: Output<PanoramaConfigResponse>?
        get() = javaResource.panoramaConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> panoramaConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Billing plan information.
     */
    public val planData: Output<PlanDataResponse>
        get() = javaResource.planData().applyValue({ args0 ->
            args0.let({ args0 ->
                planDataResponseToKotlin(args0)
            })
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallMapper : ResourceMapper<Firewall> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cloudngfw.Firewall::class == javaResource::class

    override fun map(javaResource: Resource): Firewall = Firewall(
        javaResource as
            com.pulumi.azurenative.cloudngfw.Firewall,
    )
}

/**
 * @see [Firewall].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Firewall].
 */
public suspend fun firewall(name: String, block: suspend FirewallResourceBuilder.() -> Unit): Firewall {
    val builder = FirewallResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Firewall].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewall(name: String): Firewall {
    val builder = FirewallResourceBuilder()
    builder.name(name)
    return builder.build()
}
