@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.FirewallArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.BooleanEnum
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.AzureResourceManagerManagedIdentityPropertiesArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.AzureResourceManagerManagedIdentityPropertiesArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.DNSSettingsArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.DNSSettingsArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.FrontendSettingArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.FrontendSettingArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.MarketplaceDetailsArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.MarketplaceDetailsArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.PanoramaConfigArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.PanoramaConfigArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.PlanDataArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.PlanDataArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.RulestackDetailsArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.RulestackDetailsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * PaloAltoNetworks Firewall
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### Firewalls_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewall = new AzureNative.Cloudngfw.Firewall("firewall", new()
 *     {
 *         AssociatedRulestack = new AzureNative.Cloudngfw.Inputs.RulestackDetailsArgs
 *         {
 *             Location = "eastus",
 *             ResourceId = "lrs1",
 *             RulestackId = "PANRSID",
 *         },
 *         DnsSettings = new AzureNative.Cloudngfw.Inputs.DNSSettingsArgs
 *         {
 *             DnsServers = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.111",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1",
 *                 },
 *             },
 *             EnableDnsProxy = AzureNative.Cloudngfw.DNSProxy.DISABLED,
 *             EnabledDnsType = AzureNative.Cloudngfw.EnabledDNSType.CUSTOM,
 *         },
 *         FirewallName = "firewall1",
 *         FrontEndSettings = new[]
 *         {
 *             new AzureNative.Cloudngfw.Inputs.FrontendSettingArgs
 *             {
 *                 BackendConfiguration = new AzureNative.Cloudngfw.Inputs.EndpointConfigurationArgs
 *                 {
 *                     Address = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                     {
 *                         Address = "20.22.32.136",
 *                         ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2",
 *                     },
 *                     Port = "80",
 *                 },
 *                 FrontendConfiguration = new AzureNative.Cloudngfw.Inputs.EndpointConfigurationArgs
 *                 {
 *                     Address = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                     {
 *                         Address = "20.22.91.251",
 *                         ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1",
 *                     },
 *                     Port = "80",
 *                 },
 *                 Name = "frontendsetting11",
 *                 Protocol = AzureNative.Cloudngfw.ProtocolType.TCP,
 *             },
 *         },
 *         Identity = new AzureNative.Cloudngfw.Inputs.AzureResourceManagerManagedIdentityPropertiesArgs
 *         {
 *             Type = AzureNative.Cloudngfw.ManagedIdentityType.None,
 *             UserAssignedIdentities =
 *             {
 *                 { "key16", new AzureNative.Cloudngfw.Inputs.AzureResourceManagerUserAssignedIdentityArgs
 *                 {
 *                     ClientId = "aaaa",
 *                     PrincipalId = "aaaaaaaaaaaaaaa",
 *                 } },
 *             },
 *         },
 *         IsPanoramaManaged = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         Location = "eastus",
 *         MarketplaceDetails = new AzureNative.Cloudngfw.Inputs.MarketplaceDetailsArgs
 *         {
 *             MarketplaceSubscriptionStatus = AzureNative.Cloudngfw.MarketplaceSubscriptionStatus.PendingFulfillmentStart,
 *             OfferId = "liftr-pan-ame-test",
 *             PublisherId = "isvtestuklegacy",
 *         },
 *         NetworkProfile = new AzureNative.Cloudngfw.Inputs.NetworkProfileArgs
 *         {
 *             EgressNatIp = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.111",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1",
 *                 },
 *             },
 *             EnableEgressNat = AzureNative.Cloudngfw.EgressNat.ENABLED,
 *             NetworkType = AzureNative.Cloudngfw.NetworkType.VNET,
 *             PublicIps = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.11",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1",
 *                 },
 *             },
 *             TrustedRanges = new[]
 *             {
 *                 "20.22.92.11",
 *             },
 *             VnetConfiguration = new AzureNative.Cloudngfw.Inputs.VnetConfigurationArgs
 *             {
 *                 IpOfTrustSubnetForUdr = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 TrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet",
 *                 },
 *                 UnTrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 Vnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.0.0/16",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet",
 *                 },
 *             },
 *             VwanConfiguration = new AzureNative.Cloudngfw.Inputs.VwanConfigurationArgs
 *             {
 *                 IpOfTrustSubnetForUdr = new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 NetworkVirtualApplianceId = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
 *                 TrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet",
 *                 },
 *                 UnTrustSubnet = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *                 VHub = new AzureNative.Cloudngfw.Inputs.IPAddressSpaceArgs
 *                 {
 *                     AddressSpace = "10.1.1.0/24",
 *                     ResourceId = "/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet",
 *                 },
 *             },
 *         },
 *         PanEtag = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
 *         PanoramaConfig = new AzureNative.Cloudngfw.Inputs.PanoramaConfigArgs
 *         {
 *             ConfigString = "bas64EncodedString",
 *         },
 *         PlanData = new AzureNative.Cloudngfw.Inputs.PlanDataArgs
 *         {
 *             BillingCycle = AzureNative.Cloudngfw.BillingCycle.MONTHLY,
 *             PlanId = "liftrpantestplan",
 *             UsageType = AzureNative.Cloudngfw.UsageType.PAYG,
 *         },
 *         ResourceGroupName = "firewall-rg",
 *         Tags =
 *         {
 *             { "tagName", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFirewall(ctx, "firewall", &cloudngfw.FirewallArgs{
 * 			AssociatedRulestack: &cloudngfw.RulestackDetailsArgs{
 * 				Location:    pulumi.String("eastus"),
 * 				ResourceId:  pulumi.String("lrs1"),
 * 				RulestackId: pulumi.String("PANRSID"),
 * 			},
 * 			DnsSettings: &cloudngfw.DNSSettingsArgs{
 * 				DnsServers: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.111"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
 * 					},
 * 				},
 * 				EnableDnsProxy: pulumi.String(cloudngfw.DNSProxyDISABLED),
 * 				EnabledDnsType: pulumi.String(cloudngfw.EnabledDNSTypeCUSTOM),
 * 			},
 * 			FirewallName: pulumi.String("firewall1"),
 * 			FrontEndSettings: cloudngfw.FrontendSettingArray{
 * 				&cloudngfw.FrontendSettingArgs{
 * 					BackendConfiguration: &cloudngfw.EndpointConfigurationArgs{
 * 						Address: &cloudngfw.IPAddressArgs{
 * 							Address:    pulumi.String("20.22.32.136"),
 * 							ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2"),
 * 						},
 * 						Port: pulumi.String("80"),
 * 					},
 * 					FrontendConfiguration: &cloudngfw.EndpointConfigurationArgs{
 * 						Address: &cloudngfw.IPAddressArgs{
 * 							Address:    pulumi.String("20.22.91.251"),
 * 							ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1"),
 * 						},
 * 						Port: pulumi.String("80"),
 * 					},
 * 					Name:     pulumi.String("frontendsetting11"),
 * 					Protocol: pulumi.String(cloudngfw.ProtocolTypeTCP),
 * 				},
 * 			},
 * 			Identity: &cloudngfw.AzureResourceManagerManagedIdentityPropertiesArgs{
 * 				Type: pulumi.String(cloudngfw.ManagedIdentityTypeNone),
 * 				UserAssignedIdentities: cloudngfw.AzureResourceManagerUserAssignedIdentityMap{
 * 					"key16": &cloudngfw.AzureResourceManagerUserAssignedIdentityArgs{
 * 						ClientId:    pulumi.String("aaaa"),
 * 						PrincipalId: pulumi.String("aaaaaaaaaaaaaaa"),
 * 					},
 * 				},
 * 			},
 * 			IsPanoramaManaged: pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			Location:          pulumi.String("eastus"),
 * 			MarketplaceDetails: &cloudngfw.MarketplaceDetailsArgs{
 * 				MarketplaceSubscriptionStatus: pulumi.String(cloudngfw.MarketplaceSubscriptionStatusPendingFulfillmentStart),
 * 				OfferId:                       pulumi.String("liftr-pan-ame-test"),
 * 				PublisherId:                   pulumi.String("isvtestuklegacy"),
 * 			},
 * 			NetworkProfile: &cloudngfw.NetworkProfileArgs{
 * 				EgressNatIp: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.111"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1"),
 * 					},
 * 				},
 * 				EnableEgressNat: pulumi.String(cloudngfw.EgressNatENABLED),
 * 				NetworkType:     pulumi.String(cloudngfw.NetworkTypeVNET),
 * 				PublicIps: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.11"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
 * 					},
 * 				},
 * 				TrustedRanges: pulumi.StringArray{
 * 					pulumi.String("20.22.92.11"),
 * 				},
 * 				VnetConfiguration: &cloudngfw.VnetConfigurationArgs{
 * 					IpOfTrustSubnetForUdr: &cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("10.1.1.0/24"),
 * 						ResourceId: pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					TrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
 * 					},
 * 					UnTrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					Vnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.0.0/16"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet"),
 * 					},
 * 				},
 * 				VwanConfiguration: &cloudngfw.VwanConfigurationArgs{
 * 					IpOfTrustSubnetForUdr: &cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("10.1.1.0/24"),
 * 						ResourceId: pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					NetworkVirtualApplianceId: pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
 * 					TrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet"),
 * 					},
 * 					UnTrustSubnet: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 					VHub: &cloudngfw.IPAddressSpaceArgs{
 * 						AddressSpace: pulumi.String("10.1.1.0/24"),
 * 						ResourceId:   pulumi.String("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet"),
 * 					},
 * 				},
 * 			},
 * 			PanEtag: pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
 * 			PanoramaConfig: &cloudngfw.PanoramaConfigArgs{
 * 				ConfigString: pulumi.String("bas64EncodedString"),
 * 			},
 * 			PlanData: &cloudngfw.PlanDataArgs{
 * 				BillingCycle: pulumi.String(cloudngfw.BillingCycleMONTHLY),
 * 				PlanId:       pulumi.String("liftrpantestplan"),
 * 				UsageType:    pulumi.String(cloudngfw.UsageTypePAYG),
 * 			},
 * 			ResourceGroupName: pulumi.String("firewall-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.Firewall;
 * import com.pulumi.azurenative.cloudngfw.FirewallArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.RulestackDetailsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.FrontendSettingArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.EndpointConfigurationArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.IPAddressArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.VnetConfigurationArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.IPAddressSpaceArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.VwanConfigurationArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.PanoramaConfigArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewall = new Firewall("firewall", FirewallArgs.builder()
 *             .associatedRulestack(RulestackDetailsArgs.builder()
 *                 .location("eastus")
 *                 .resourceId("lrs1")
 *                 .rulestackId("PANRSID")
 *                 .build())
 *             .dnsSettings(DNSSettingsArgs.builder()
 *                 .dnsServers(IPAddressArgs.builder()
 *                     .address("20.22.92.111")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1")
 *                     .build())
 *                 .enableDnsProxy("DISABLED")
 *                 .enabledDnsType("CUSTOM")
 *                 .build())
 *             .firewallName("firewall1")
 *             .frontEndSettings(FrontendSettingArgs.builder()
 *                 .backendConfiguration(EndpointConfigurationArgs.builder()
 *                     .address(IPAddressArgs.builder()
 *                         .address("20.22.32.136")
 *                         .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp2")
 *                         .build())
 *                     .port("80")
 *                     .build())
 *                 .frontendConfiguration(EndpointConfigurationArgs.builder()
 *                     .address(IPAddressArgs.builder()
 *                         .address("20.22.91.251")
 *                         .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-frontendSettingIp1")
 *                         .build())
 *                     .port("80")
 *                     .build())
 *                 .name("frontendsetting11")
 *                 .protocol("TCP")
 *                 .build())
 *             .identity(AzureResourceManagerManagedIdentityPropertiesArgs.builder()
 *                 .type("None")
 *                 .userAssignedIdentities(Map.of("key16", Map.ofEntries(
 *                     Map.entry("clientId", "aaaa"),
 *                     Map.entry("principalId", "aaaaaaaaaaaaaaa")
 *                 )))
 *                 .build())
 *             .isPanoramaManaged("TRUE")
 *             .location("eastus")
 *             .marketplaceDetails(MarketplaceDetailsArgs.builder()
 *                 .marketplaceSubscriptionStatus("PendingFulfillmentStart")
 *                 .offerId("liftr-pan-ame-test")
 *                 .publisherId("isvtestuklegacy")
 *                 .build())
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .egressNatIp(IPAddressArgs.builder()
 *                     .address("20.22.92.111")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-egressNatIp1")
 *                     .build())
 *                 .enableEgressNat("ENABLED")
 *                 .networkType("VNET")
 *                 .publicIps(IPAddressArgs.builder()
 *                     .address("20.22.92.11")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1")
 *                     .build())
 *                 .trustedRanges("20.22.92.11")
 *                 .vnetConfiguration(VnetConfigurationArgs.builder()
 *                     .ipOfTrustSubnetForUdr(IPAddressArgs.builder()
 *                         .address("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .trustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet")
 *                         .build())
 *                     .unTrustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .vnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.0.0/16")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet")
 *                         .build())
 *                     .build())
 *                 .vwanConfiguration(VwanConfigurationArgs.builder()
 *                     .ipOfTrustSubnetForUdr(IPAddressArgs.builder()
 *                         .address("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .networkVirtualApplianceId("2bf4a339-294d-4c25-b0b2-ef649e9f5c12")
 *                     .trustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-trust-subnet")
 *                         .build())
 *                     .unTrustSubnet(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .vHub(IPAddressSpaceArgs.builder()
 *                         .addressSpace("10.1.1.0/24")
 *                         .resourceId("/subscriptions/2bf4a339-294d-4c25-b0b2-ef649e9f5c27/resourceGroups/os-liftr-integration/providers/Microsoft.Network/virtualNetworks/os-liftr-integration-vnet/subnets/os-liftr-integration-untrust-subnet")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .panEtag("2bf4a339-294d-4c25-b0b2-ef649e9f5c12")
 *             .panoramaConfig(PanoramaConfigArgs.builder()
 *                 .configString("bas64EncodedString")
 *                 .build())
 *             .planData(PlanDataArgs.builder()
 *                 .billingCycle("MONTHLY")
 *                 .planId("liftrpantestplan")
 *                 .usageType("PAYG")
 *                 .build())
 *             .resourceGroupName("firewall-rg")
 *             .tags(Map.of("tagName", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### Firewalls_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewall = new AzureNative.Cloudngfw.Firewall("firewall", new()
 *     {
 *         DnsSettings = null,
 *         FirewallName = "firewall1",
 *         Location = "eastus",
 *         MarketplaceDetails = new AzureNative.Cloudngfw.Inputs.MarketplaceDetailsArgs
 *         {
 *             OfferId = "liftr-pan-ame-test",
 *             PublisherId = "isvtestuklegacy",
 *         },
 *         NetworkProfile = new AzureNative.Cloudngfw.Inputs.NetworkProfileArgs
 *         {
 *             EnableEgressNat = AzureNative.Cloudngfw.EgressNat.ENABLED,
 *             NetworkType = AzureNative.Cloudngfw.NetworkType.VNET,
 *             PublicIps = new[]
 *             {
 *                 new AzureNative.Cloudngfw.Inputs.IPAddressArgs
 *                 {
 *                     Address = "20.22.92.11",
 *                     ResourceId = "/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1",
 *                 },
 *             },
 *         },
 *         PlanData = new AzureNative.Cloudngfw.Inputs.PlanDataArgs
 *         {
 *             BillingCycle = AzureNative.Cloudngfw.BillingCycle.MONTHLY,
 *             PlanId = "liftrpantestplan",
 *         },
 *         ResourceGroupName = "firewall-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFirewall(ctx, "firewall", &cloudngfw.FirewallArgs{
 * 			DnsSettings:  nil,
 * 			FirewallName: pulumi.String("firewall1"),
 * 			Location:     pulumi.String("eastus"),
 * 			MarketplaceDetails: &cloudngfw.MarketplaceDetailsArgs{
 * 				OfferId:     pulumi.String("liftr-pan-ame-test"),
 * 				PublisherId: pulumi.String("isvtestuklegacy"),
 * 			},
 * 			NetworkProfile: &cloudngfw.NetworkProfileArgs{
 * 				EnableEgressNat: pulumi.String(cloudngfw.EgressNatENABLED),
 * 				NetworkType:     pulumi.String(cloudngfw.NetworkTypeVNET),
 * 				PublicIps: cloudngfw.IPAddressArray{
 * 					&cloudngfw.IPAddressArgs{
 * 						Address:    pulumi.String("20.22.92.11"),
 * 						ResourceId: pulumi.String("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1"),
 * 					},
 * 				},
 * 			},
 * 			PlanData: &cloudngfw.PlanDataArgs{
 * 				BillingCycle: pulumi.String(cloudngfw.BillingCycleMONTHLY),
 * 				PlanId:       pulumi.String("liftrpantestplan"),
 * 			},
 * 			ResourceGroupName: pulumi.String("firewall-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.Firewall;
 * import com.pulumi.azurenative.cloudngfw.FirewallArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.DNSSettingsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.PlanDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewall = new Firewall("firewall", FirewallArgs.builder()
 *             .dnsSettings()
 *             .firewallName("firewall1")
 *             .location("eastus")
 *             .marketplaceDetails(MarketplaceDetailsArgs.builder()
 *                 .offerId("liftr-pan-ame-test")
 *                 .publisherId("isvtestuklegacy")
 *                 .build())
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .enableEgressNat("ENABLED")
 *                 .networkType("VNET")
 *                 .publicIps(IPAddressArgs.builder()
 *                     .address("20.22.92.11")
 *                     .resourceId("/subscriptions/01c7d41f-afaf-464e-8a8b-5c6f9f98cee8/resourceGroups/mj-liftr-integration/providers/Microsoft.Network/publicIPAddresses/mj-liftr-integration-PublicIp1")
 *                     .build())
 *                 .build())
 *             .planData(PlanDataArgs.builder()
 *                 .billingCycle("MONTHLY")
 *                 .planId("liftrpantestplan")
 *                 .build())
 *             .resourceGroupName("firewall-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:Firewall armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/firewalls/{firewallName}
 * ```
 * @property associatedRulestack Associated Rulestack
 * @property dnsSettings DNS settings for Firewall
 * @property firewallName Firewall resource name
 * @property frontEndSettings Frontend settings for Firewall
 * @property identity The managed service identities assigned to this resource.
 * @property isPanoramaManaged Panorama Managed: Default is False. Default will be CloudSec managed
 * @property location The geo-location where the resource lives
 * @property marketplaceDetails Marketplace details
 * @property networkProfile Network settings
 * @property panEtag panEtag info
 * @property panoramaConfig Panorama Configuration
 * @property planData Billing plan information.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class FirewallArgs(
    public val associatedRulestack: Output<RulestackDetailsArgs>? = null,
    public val dnsSettings: Output<DNSSettingsArgs>? = null,
    public val firewallName: Output<String>? = null,
    public val frontEndSettings: Output<List<FrontendSettingArgs>>? = null,
    public val identity: Output<AzureResourceManagerManagedIdentityPropertiesArgs>? = null,
    public val isPanoramaManaged: Output<Either<String, BooleanEnum>>? = null,
    public val location: Output<String>? = null,
    public val marketplaceDetails: Output<MarketplaceDetailsArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val panEtag: Output<String>? = null,
    public val panoramaConfig: Output<PanoramaConfigArgs>? = null,
    public val planData: Output<PlanDataArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.FirewallArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.FirewallArgs =
        com.pulumi.azurenative.cloudngfw.FirewallArgs.builder()
            .associatedRulestack(
                associatedRulestack?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firewallName(firewallName?.applyValue({ args0 -> args0 }))
            .frontEndSettings(
                frontEndSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isPanoramaManaged(
                isPanoramaManaged?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .marketplaceDetails(
                marketplaceDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .panEtag(panEtag?.applyValue({ args0 -> args0 }))
            .panoramaConfig(panoramaConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .planData(planData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FirewallArgs].
 */
@PulumiTagMarker
public class FirewallArgsBuilder internal constructor() {
    private var associatedRulestack: Output<RulestackDetailsArgs>? = null

    private var dnsSettings: Output<DNSSettingsArgs>? = null

    private var firewallName: Output<String>? = null

    private var frontEndSettings: Output<List<FrontendSettingArgs>>? = null

    private var identity: Output<AzureResourceManagerManagedIdentityPropertiesArgs>? = null

    private var isPanoramaManaged: Output<Either<String, BooleanEnum>>? = null

    private var location: Output<String>? = null

    private var marketplaceDetails: Output<MarketplaceDetailsArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var panEtag: Output<String>? = null

    private var panoramaConfig: Output<PanoramaConfigArgs>? = null

    private var planData: Output<PlanDataArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Associated Rulestack
     */
    @JvmName("xadmsvfyapyxdfvr")
    public suspend fun associatedRulestack(`value`: Output<RulestackDetailsArgs>) {
        this.associatedRulestack = value
    }

    /**
     * @param value DNS settings for Firewall
     */
    @JvmName("amiwniiesqndaqsw")
    public suspend fun dnsSettings(`value`: Output<DNSSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value Firewall resource name
     */
    @JvmName("qvgagbuqtpdvwwsk")
    public suspend fun firewallName(`value`: Output<String>) {
        this.firewallName = value
    }

    /**
     * @param value Frontend settings for Firewall
     */
    @JvmName("nojxwheqxhnanwtw")
    public suspend fun frontEndSettings(`value`: Output<List<FrontendSettingArgs>>) {
        this.frontEndSettings = value
    }

    @JvmName("eqtygjkamwaxyjcx")
    public suspend fun frontEndSettings(vararg values: Output<FrontendSettingArgs>) {
        this.frontEndSettings = Output.all(values.asList())
    }

    /**
     * @param values Frontend settings for Firewall
     */
    @JvmName("wkckxiucilbktalp")
    public suspend fun frontEndSettings(values: List<Output<FrontendSettingArgs>>) {
        this.frontEndSettings = Output.all(values)
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("ejqtjlauttnnlike")
    public suspend fun identity(`value`: Output<AzureResourceManagerManagedIdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value Panorama Managed: Default is False. Default will be CloudSec managed
     */
    @JvmName("qbjlqdveciseuwum")
    public suspend fun isPanoramaManaged(`value`: Output<Either<String, BooleanEnum>>) {
        this.isPanoramaManaged = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ktxneboavwofpbbe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Marketplace details
     */
    @JvmName("gyyfixxjvnjcehwq")
    public suspend fun marketplaceDetails(`value`: Output<MarketplaceDetailsArgs>) {
        this.marketplaceDetails = value
    }

    /**
     * @param value Network settings
     */
    @JvmName("imyuooibugfcbibo")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value panEtag info
     */
    @JvmName("tuowwvmknifxshrp")
    public suspend fun panEtag(`value`: Output<String>) {
        this.panEtag = value
    }

    /**
     * @param value Panorama Configuration
     */
    @JvmName("aiklhaobpkqlyuse")
    public suspend fun panoramaConfig(`value`: Output<PanoramaConfigArgs>) {
        this.panoramaConfig = value
    }

    /**
     * @param value Billing plan information.
     */
    @JvmName("uybykexllklisixp")
    public suspend fun planData(`value`: Output<PlanDataArgs>) {
        this.planData = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gtxdtxvlisjgdvne")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fhhwwwepwvwnnoaq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Associated Rulestack
     */
    @JvmName("nldytkwbuybdqull")
    public suspend fun associatedRulestack(`value`: RulestackDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedRulestack = mapped
    }

    /**
     * @param argument Associated Rulestack
     */
    @JvmName("osbomboehphfkeyo")
    public suspend fun associatedRulestack(argument: suspend RulestackDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = RulestackDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.associatedRulestack = mapped
    }

    /**
     * @param value DNS settings for Firewall
     */
    @JvmName("gnhaqixdeunsyaro")
    public suspend fun dnsSettings(`value`: DNSSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument DNS settings for Firewall
     */
    @JvmName("irsjbifkmctsnrmt")
    public suspend fun dnsSettings(argument: suspend DNSSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DNSSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value Firewall resource name
     */
    @JvmName("uuhniugdbniemxhi")
    public suspend fun firewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallName = mapped
    }

    /**
     * @param value Frontend settings for Firewall
     */
    @JvmName("seaefxxjfysneors")
    public suspend fun frontEndSettings(`value`: List<FrontendSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontEndSettings = mapped
    }

    /**
     * @param argument Frontend settings for Firewall
     */
    @JvmName("ryhvamjyplxlbqig")
    public suspend fun frontEndSettings(argument: List<suspend FrontendSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontEndSettings = mapped
    }

    /**
     * @param argument Frontend settings for Firewall
     */
    @JvmName("whsnefrjwrpewrhr")
    public suspend fun frontEndSettings(vararg argument: suspend FrontendSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FrontendSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontEndSettings = mapped
    }

    /**
     * @param argument Frontend settings for Firewall
     */
    @JvmName("huvlrrtcqwwdprjr")
    public suspend fun frontEndSettings(argument: suspend FrontendSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FrontendSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.frontEndSettings = mapped
    }

    /**
     * @param values Frontend settings for Firewall
     */
    @JvmName("epwfhfaihbunwtwo")
    public suspend fun frontEndSettings(vararg values: FrontendSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontEndSettings = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("ylsipfgqhkienspo")
    public suspend fun identity(`value`: AzureResourceManagerManagedIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("qjvsacljvdabnawk")
    public suspend fun identity(argument: suspend AzureResourceManagerManagedIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureResourceManagerManagedIdentityPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Panorama Managed: Default is False. Default will be CloudSec managed
     */
    @JvmName("sadyavmtwvwesbro")
    public suspend fun isPanoramaManaged(`value`: Either<String, BooleanEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPanoramaManaged = mapped
    }

    /**
     * @param value Panorama Managed: Default is False. Default will be CloudSec managed
     */
    @JvmName("wpsotcnkxxrkwngj")
    public fun isPanoramaManaged(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isPanoramaManaged = mapped
    }

    /**
     * @param value Panorama Managed: Default is False. Default will be CloudSec managed
     */
    @JvmName("qqigbgfffsvvkqef")
    public fun isPanoramaManaged(`value`: BooleanEnum) {
        val toBeMapped = Either.ofRight<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isPanoramaManaged = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vwudwkobljtxqgtg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Marketplace details
     */
    @JvmName("ppjoxauiitqfpnou")
    public suspend fun marketplaceDetails(`value`: MarketplaceDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceDetails = mapped
    }

    /**
     * @param argument Marketplace details
     */
    @JvmName("iojqssghlwdsjqhf")
    public suspend fun marketplaceDetails(argument: suspend MarketplaceDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = MarketplaceDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.marketplaceDetails = mapped
    }

    /**
     * @param value Network settings
     */
    @JvmName("wacgajftdrbesmbb")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Network settings
     */
    @JvmName("oxpmdfrojfivykmd")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value panEtag info
     */
    @JvmName("rneqxiqniwgysvhi")
    public suspend fun panEtag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.panEtag = mapped
    }

    /**
     * @param value Panorama Configuration
     */
    @JvmName("fbpveqtfivqfvdmd")
    public suspend fun panoramaConfig(`value`: PanoramaConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.panoramaConfig = mapped
    }

    /**
     * @param argument Panorama Configuration
     */
    @JvmName("dgklymbeppblxnsj")
    public suspend fun panoramaConfig(argument: suspend PanoramaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = PanoramaConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.panoramaConfig = mapped
    }

    /**
     * @param value Billing plan information.
     */
    @JvmName("jnfuxgqsaphgnckm")
    public suspend fun planData(`value`: PlanDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planData = mapped
    }

    /**
     * @param argument Billing plan information.
     */
    @JvmName("hhhqdbhrhdiluvbw")
    public suspend fun planData(argument: suspend PlanDataArgsBuilder.() -> Unit) {
        val toBeMapped = PlanDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.planData = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lrctmrknhtrbbtuq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bwrutarebtdljbvx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jsmmqhrfhykvqcfw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FirewallArgs = FirewallArgs(
        associatedRulestack = associatedRulestack,
        dnsSettings = dnsSettings,
        firewallName = firewallName,
        frontEndSettings = frontEndSettings,
        identity = identity,
        isPanoramaManaged = isPanoramaManaged,
        location = location,
        marketplaceDetails = marketplaceDetails,
        networkProfile = networkProfile,
        panEtag = panEtag,
        panoramaConfig = panoramaConfig,
        planData = planData,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
