@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FqdnListGlobalRulestack].
 */
@PulumiTagMarker
public class FqdnListGlobalRulestackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FqdnListGlobalRulestackArgs = FqdnListGlobalRulestackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FqdnListGlobalRulestackArgsBuilder.() -> Unit) {
        val builder = FqdnListGlobalRulestackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FqdnListGlobalRulestack {
        val builtJavaResource =
            com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FqdnListGlobalRulestack(builtJavaResource)
    }
}

/**
 * GlobalRulestack fqdnList
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### FqdnListGlobalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListGlobalRulestack = new AzureNative.Cloudngfw.FqdnListGlobalRulestack("fqdnListGlobalRulestack", new()
 *     {
 *         AuditComment = "string",
 *         Description = "string",
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListGlobalRulestack(ctx, "fqdnListGlobalRulestack", &cloudngfw.FqdnListGlobalRulestackArgs{
 * 			AuditComment: pulumi.String("string"),
 * 			Description:  pulumi.String("string"),
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Name:                pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListGlobalRulestack = new FqdnListGlobalRulestack("fqdnListGlobalRulestack", FqdnListGlobalRulestackArgs.builder()
 *             .auditComment("string")
 *             .description("string")
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ### FqdnListGlobalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListGlobalRulestack = new AzureNative.Cloudngfw.FqdnListGlobalRulestack("fqdnListGlobalRulestack", new()
 *     {
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListGlobalRulestack(ctx, "fqdnListGlobalRulestack", &cloudngfw.FqdnListGlobalRulestackArgs{
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Name:                pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListGlobalRulestack = new FqdnListGlobalRulestack("fqdnListGlobalRulestack", FqdnListGlobalRulestackArgs.builder()
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:FqdnListGlobalRulestack armid1 /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/fqdnlists/{name}
 * ```
 */
public class FqdnListGlobalRulestack internal constructor(
    override val javaResource: com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack,
) : KotlinCustomResource(javaResource, FqdnListGlobalRulestackMapper) {
    /**
     * comment for this object
     */
    public val auditComment: Output<String>?
        get() = javaResource.auditComment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * fqdn object description
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * etag info
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * fqdn list
     */
    public val fqdnList: Output<List<String>>
        get() = javaResource.fqdnList().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FqdnListGlobalRulestackMapper : ResourceMapper<FqdnListGlobalRulestack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack::class == javaResource::class

    override fun map(javaResource: Resource): FqdnListGlobalRulestack =
        FqdnListGlobalRulestack(
            javaResource as
                com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack,
        )
}

/**
 * @see [FqdnListGlobalRulestack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FqdnListGlobalRulestack].
 */
public suspend fun fqdnListGlobalRulestack(
    name: String,
    block: suspend FqdnListGlobalRulestackResourceBuilder.() -> Unit,
): FqdnListGlobalRulestack {
    val builder = FqdnListGlobalRulestackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FqdnListGlobalRulestack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fqdnListGlobalRulestack(name: String): FqdnListGlobalRulestack {
    val builder = FqdnListGlobalRulestackResourceBuilder()
    builder.name(name)
    return builder.build()
}
