@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * GlobalRulestack fqdnList
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### FqdnListGlobalRulestack_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListGlobalRulestack = new AzureNative.Cloudngfw.FqdnListGlobalRulestack("fqdnListGlobalRulestack", new()
 *     {
 *         AuditComment = "string",
 *         Description = "string",
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListGlobalRulestack(ctx, "fqdnListGlobalRulestack", &cloudngfw.FqdnListGlobalRulestackArgs{
 * 			AuditComment: pulumi.String("string"),
 * 			Description:  pulumi.String("string"),
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Name:                pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListGlobalRulestack = new FqdnListGlobalRulestack("fqdnListGlobalRulestack", FqdnListGlobalRulestackArgs.builder()
 *             .auditComment("string")
 *             .description("string")
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ### FqdnListGlobalRulestack_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fqdnListGlobalRulestack = new AzureNative.Cloudngfw.FqdnListGlobalRulestack("fqdnListGlobalRulestack", new()
 *     {
 *         FqdnList = new[]
 *         {
 *             "string1",
 *             "string2",
 *         },
 *         GlobalRulestackName = "praval",
 *         Name = "armid1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewFqdnListGlobalRulestack(ctx, "fqdnListGlobalRulestack", &cloudngfw.FqdnListGlobalRulestackArgs{
 * 			FqdnList: pulumi.StringArray{
 * 				pulumi.String("string1"),
 * 				pulumi.String("string2"),
 * 			},
 * 			GlobalRulestackName: pulumi.String("praval"),
 * 			Name:                pulumi.String("armid1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestack;
 * import com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fqdnListGlobalRulestack = new FqdnListGlobalRulestack("fqdnListGlobalRulestack", FqdnListGlobalRulestackArgs.builder()
 *             .fqdnList(
 *                 "string1",
 *                 "string2")
 *             .globalRulestackName("praval")
 *             .name("armid1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:FqdnListGlobalRulestack armid1 /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/fqdnlists/{name}
 * ```
 * @property auditComment comment for this object
 * @property description fqdn object description
 * @property fqdnList fqdn list
 * @property globalRulestackName GlobalRulestack resource name
 * @property name fqdn list name
 */
public data class FqdnListGlobalRulestackArgs(
    public val auditComment: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fqdnList: Output<List<String>>? = null,
    public val globalRulestackName: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.FqdnListGlobalRulestackArgs.builder()
            .auditComment(auditComment?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fqdnList(fqdnList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .globalRulestackName(globalRulestackName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FqdnListGlobalRulestackArgs].
 */
@PulumiTagMarker
public class FqdnListGlobalRulestackArgsBuilder internal constructor() {
    private var auditComment: Output<String>? = null

    private var description: Output<String>? = null

    private var fqdnList: Output<List<String>>? = null

    private var globalRulestackName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value comment for this object
     */
    @JvmName("ihmmchrwmlnsbmxq")
    public suspend fun auditComment(`value`: Output<String>) {
        this.auditComment = value
    }

    /**
     * @param value fqdn object description
     */
    @JvmName("bxrqqwugqjfiinbr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value fqdn list
     */
    @JvmName("qqxwnaxeefcoswht")
    public suspend fun fqdnList(`value`: Output<List<String>>) {
        this.fqdnList = value
    }

    @JvmName("avptgtbfkuhsmvue")
    public suspend fun fqdnList(vararg values: Output<String>) {
        this.fqdnList = Output.all(values.asList())
    }

    /**
     * @param values fqdn list
     */
    @JvmName("yeisdhpydqfablon")
    public suspend fun fqdnList(values: List<Output<String>>) {
        this.fqdnList = Output.all(values)
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("onffufmcgyjluvxk")
    public suspend fun globalRulestackName(`value`: Output<String>) {
        this.globalRulestackName = value
    }

    /**
     * @param value fqdn list name
     */
    @JvmName("duxikxwvmyxjqvfw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value comment for this object
     */
    @JvmName("qofairfickikgxff")
    public suspend fun auditComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditComment = mapped
    }

    /**
     * @param value fqdn object description
     */
    @JvmName("fjelbrpnydpuyjba")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value fqdn list
     */
    @JvmName("vpsompqxqefoxkwg")
    public suspend fun fqdnList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnList = mapped
    }

    /**
     * @param values fqdn list
     */
    @JvmName("xajwxwdywcfiuktm")
    public suspend fun fqdnList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnList = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("avgyaghghoowdcte")
    public suspend fun globalRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalRulestackName = mapped
    }

    /**
     * @param value fqdn list name
     */
    @JvmName("sftfwshhijslpotl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): FqdnListGlobalRulestackArgs = FqdnListGlobalRulestackArgs(
        auditComment = auditComment,
        description = description,
        fqdnList = fqdnList,
        globalRulestackName = globalRulestackName,
        name = name,
    )
}
