@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.kotlin.outputs.AzureResourceManagerManagedIdentityPropertiesResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SecurityServicesResponse
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.AzureResourceManagerManagedIdentityPropertiesResponse.Companion.toKotlin as azureResourceManagerManagedIdentityPropertiesResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SecurityServicesResponse.Companion.toKotlin as securityServicesResponseToKotlin
import com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LocalRulestack].
 */
@PulumiTagMarker
public class LocalRulestackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocalRulestackArgs = LocalRulestackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocalRulestackArgsBuilder.() -> Unit) {
        val builder = LocalRulestackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocalRulestack {
        val builtJavaResource = com.pulumi.azurenative.cloudngfw.LocalRulestack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocalRulestack(builtJavaResource)
    }
}

/**
 * PaloAltoNetworks LocalRulestack
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### LocalRulestacks_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localRulestack = new AzureNative.Cloudngfw.LocalRulestack("localRulestack", new()
 *     {
 *         AssociatedSubscriptions = new[]
 *         {
 *             "2bf4a339-294d-4c25-b0b2-ef649e9f5c27",
 *         },
 *         DefaultMode = AzureNative.Cloudngfw.DefaultMode.IPS,
 *         Description = "local rulestacks",
 *         Identity = new AzureNative.Cloudngfw.Inputs.AzureResourceManagerManagedIdentityPropertiesArgs
 *         {
 *             Type = AzureNative.Cloudngfw.ManagedIdentityType.None,
 *             UserAssignedIdentities =
 *             {
 *                 { "key16", new AzureNative.Cloudngfw.Inputs.AzureResourceManagerUserAssignedIdentityArgs
 *                 {
 *                     ClientId = "aaaa",
 *                     PrincipalId = "aaaaaaaaaaaaaaa",
 *                 } },
 *             },
 *         },
 *         LocalRulestackName = "lrs1",
 *         Location = "eastus",
 *         MinAppIdVersion = "8.5.3",
 *         PanEtag = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
 *         PanLocation = "eastus",
 *         ResourceGroupName = "rgopenapi",
 *         Scope = AzureNative.Cloudngfw.ScopeType.LOCAL,
 *         SecurityServices = new AzureNative.Cloudngfw.Inputs.SecurityServicesArgs
 *         {
 *             AntiSpywareProfile = "default",
 *             AntiVirusProfile = "default",
 *             DnsSubscription = "default",
 *             FileBlockingProfile = "default",
 *             OutboundTrustCertificate = "default",
 *             OutboundUnTrustCertificate = "default",
 *             UrlFilteringProfile = "default",
 *             VulnerabilityProfile = "default",
 *         },
 *         Tags =
 *         {
 *             { "tagName", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewLocalRulestack(ctx, "localRulestack", &cloudngfw.LocalRulestackArgs{
 * 			AssociatedSubscriptions: pulumi.StringArray{
 * 				pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c27"),
 * 			},
 * 			DefaultMode: pulumi.String(cloudngfw.DefaultModeIPS),
 * 			Description: pulumi.String("local rulestacks"),
 * 			Identity: &cloudngfw.AzureResourceManagerManagedIdentityPropertiesArgs{
 * 				Type: pulumi.String(cloudngfw.ManagedIdentityTypeNone),
 * 				UserAssignedIdentities: cloudngfw.AzureResourceManagerUserAssignedIdentityMap{
 * 					"key16": &cloudngfw.AzureResourceManagerUserAssignedIdentityArgs{
 * 						ClientId:    pulumi.String("aaaa"),
 * 						PrincipalId: pulumi.String("aaaaaaaaaaaaaaa"),
 * 					},
 * 				},
 * 			},
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Location:           pulumi.String("eastus"),
 * 			MinAppIdVersion:    pulumi.String("8.5.3"),
 * 			PanEtag:            pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
 * 			PanLocation:        pulumi.String("eastus"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 			Scope:              pulumi.String(cloudngfw.ScopeTypeLOCAL),
 * 			SecurityServices: &cloudngfw.SecurityServicesArgs{
 * 				AntiSpywareProfile:         pulumi.String("default"),
 * 				AntiVirusProfile:           pulumi.String("default"),
 * 				DnsSubscription:            pulumi.String("default"),
 * 				FileBlockingProfile:        pulumi.String("default"),
 * 				OutboundTrustCertificate:   pulumi.String("default"),
 * 				OutboundUnTrustCertificate: pulumi.String("default"),
 * 				UrlFilteringProfile:        pulumi.String("default"),
 * 				VulnerabilityProfile:       pulumi.String("default"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagName": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestackArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.SecurityServicesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localRulestack = new LocalRulestack("localRulestack", LocalRulestackArgs.builder()
 *             .associatedSubscriptions("2bf4a339-294d-4c25-b0b2-ef649e9f5c27")
 *             .defaultMode("IPS")
 *             .description("local rulestacks")
 *             .identity(AzureResourceManagerManagedIdentityPropertiesArgs.builder()
 *                 .type("None")
 *                 .userAssignedIdentities(Map.of("key16", Map.ofEntries(
 *                     Map.entry("clientId", "aaaa"),
 *                     Map.entry("principalId", "aaaaaaaaaaaaaaa")
 *                 )))
 *                 .build())
 *             .localRulestackName("lrs1")
 *             .location("eastus")
 *             .minAppIdVersion("8.5.3")
 *             .panEtag("2bf4a339-294d-4c25-b0b2-ef649e9f5c12")
 *             .panLocation("eastus")
 *             .resourceGroupName("rgopenapi")
 *             .scope("LOCAL")
 *             .securityServices(SecurityServicesArgs.builder()
 *                 .antiSpywareProfile("default")
 *                 .antiVirusProfile("default")
 *                 .dnsSubscription("default")
 *                 .fileBlockingProfile("default")
 *                 .outboundTrustCertificate("default")
 *                 .outboundUnTrustCertificate("default")
 *                 .urlFilteringProfile("default")
 *                 .vulnerabilityProfile("default")
 *                 .build())
 *             .tags(Map.of("tagName", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### LocalRulestacks_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localRulestack = new AzureNative.Cloudngfw.LocalRulestack("localRulestack", new()
 *     {
 *         LocalRulestackName = "lrs1",
 *         Location = "eastus",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewLocalRulestack(ctx, "localRulestack", &cloudngfw.LocalRulestackArgs{
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Location:           pulumi.String("eastus"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localRulestack = new LocalRulestack("localRulestack", LocalRulestackArgs.builder()
 *             .localRulestackName("lrs1")
 *             .location("eastus")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:LocalRulestack armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}
 * ```
 */
public class LocalRulestack internal constructor(
    override val javaResource: com.pulumi.azurenative.cloudngfw.LocalRulestack,
) : KotlinCustomResource(javaResource, LocalRulestackMapper) {
    /**
     * subscription scope of global rulestack
     */
    public val associatedSubscriptions: Output<List<String>>?
        get() = javaResource.associatedSubscriptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Mode for default rules creation
     */
    public val defaultMode: Output<String>?
        get() = javaResource.defaultMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * rulestack description
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<AzureResourceManagerManagedIdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    azureResourceManagerManagedIdentityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * minimum version
     */
    public val minAppIdVersion: Output<String>?
        get() = javaResource.minAppIdVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * PanEtag info
     */
    public val panEtag: Output<String>?
        get() = javaResource.panEtag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
     */
    public val panLocation: Output<String>?
        get() = javaResource.panLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Rulestack Type
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Security Profile
     */
    public val securityServices: Output<SecurityServicesResponse>?
        get() = javaResource.securityServices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityServicesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LocalRulestackMapper : ResourceMapper<LocalRulestack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cloudngfw.LocalRulestack::class == javaResource::class

    override fun map(javaResource: Resource): LocalRulestack = LocalRulestack(
        javaResource as
            com.pulumi.azurenative.cloudngfw.LocalRulestack,
    )
}

/**
 * @see [LocalRulestack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocalRulestack].
 */
public suspend fun localRulestack(
    name: String,
    block: suspend LocalRulestackResourceBuilder.() -> Unit,
): LocalRulestack {
    val builder = LocalRulestackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocalRulestack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun localRulestack(name: String): LocalRulestack {
    val builder = LocalRulestackResourceBuilder()
    builder.name(name)
    return builder.build()
}
