@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.LocalRulestackArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.DefaultMode
import com.pulumi.azurenative.cloudngfw.kotlin.enums.ScopeType
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.AzureResourceManagerManagedIdentityPropertiesArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.AzureResourceManagerManagedIdentityPropertiesArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.SecurityServicesArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.SecurityServicesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * PaloAltoNetworks LocalRulestack
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### LocalRulestacks_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localRulestack = new AzureNative.Cloudngfw.LocalRulestack("localRulestack", new()
 *     {
 *         AssociatedSubscriptions = new[]
 *         {
 *             "2bf4a339-294d-4c25-b0b2-ef649e9f5c27",
 *         },
 *         DefaultMode = AzureNative.Cloudngfw.DefaultMode.IPS,
 *         Description = "local rulestacks",
 *         Identity = new AzureNative.Cloudngfw.Inputs.AzureResourceManagerManagedIdentityPropertiesArgs
 *         {
 *             Type = AzureNative.Cloudngfw.ManagedIdentityType.None,
 *             UserAssignedIdentities =
 *             {
 *                 { "key16", new AzureNative.Cloudngfw.Inputs.AzureResourceManagerUserAssignedIdentityArgs
 *                 {
 *                     ClientId = "aaaa",
 *                     PrincipalId = "aaaaaaaaaaaaaaa",
 *                 } },
 *             },
 *         },
 *         LocalRulestackName = "lrs1",
 *         Location = "eastus",
 *         MinAppIdVersion = "8.5.3",
 *         PanEtag = "2bf4a339-294d-4c25-b0b2-ef649e9f5c12",
 *         PanLocation = "eastus",
 *         ResourceGroupName = "rgopenapi",
 *         Scope = AzureNative.Cloudngfw.ScopeType.LOCAL,
 *         SecurityServices = new AzureNative.Cloudngfw.Inputs.SecurityServicesArgs
 *         {
 *             AntiSpywareProfile = "default",
 *             AntiVirusProfile = "default",
 *             DnsSubscription = "default",
 *             FileBlockingProfile = "default",
 *             OutboundTrustCertificate = "default",
 *             OutboundUnTrustCertificate = "default",
 *             UrlFilteringProfile = "default",
 *             VulnerabilityProfile = "default",
 *         },
 *         Tags =
 *         {
 *             { "tagName", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewLocalRulestack(ctx, "localRulestack", &cloudngfw.LocalRulestackArgs{
 * 			AssociatedSubscriptions: pulumi.StringArray{
 * 				pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c27"),
 * 			},
 * 			DefaultMode: pulumi.String(cloudngfw.DefaultModeIPS),
 * 			Description: pulumi.String("local rulestacks"),
 * 			Identity: &cloudngfw.AzureResourceManagerManagedIdentityPropertiesArgs{
 * 				Type: pulumi.String(cloudngfw.ManagedIdentityTypeNone),
 * 				UserAssignedIdentities: cloudngfw.AzureResourceManagerUserAssignedIdentityMap{
 * 					"key16": &cloudngfw.AzureResourceManagerUserAssignedIdentityArgs{
 * 						ClientId:    pulumi.String("aaaa"),
 * 						PrincipalId: pulumi.String("aaaaaaaaaaaaaaa"),
 * 					},
 * 				},
 * 			},
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Location:           pulumi.String("eastus"),
 * 			MinAppIdVersion:    pulumi.String("8.5.3"),
 * 			PanEtag:            pulumi.String("2bf4a339-294d-4c25-b0b2-ef649e9f5c12"),
 * 			PanLocation:        pulumi.String("eastus"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 			Scope:              pulumi.String(cloudngfw.ScopeTypeLOCAL),
 * 			SecurityServices: &cloudngfw.SecurityServicesArgs{
 * 				AntiSpywareProfile:         pulumi.String("default"),
 * 				AntiVirusProfile:           pulumi.String("default"),
 * 				DnsSubscription:            pulumi.String("default"),
 * 				FileBlockingProfile:        pulumi.String("default"),
 * 				OutboundTrustCertificate:   pulumi.String("default"),
 * 				OutboundUnTrustCertificate: pulumi.String("default"),
 * 				UrlFilteringProfile:        pulumi.String("default"),
 * 				VulnerabilityProfile:       pulumi.String("default"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagName": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestackArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.SecurityServicesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localRulestack = new LocalRulestack("localRulestack", LocalRulestackArgs.builder()
 *             .associatedSubscriptions("2bf4a339-294d-4c25-b0b2-ef649e9f5c27")
 *             .defaultMode("IPS")
 *             .description("local rulestacks")
 *             .identity(AzureResourceManagerManagedIdentityPropertiesArgs.builder()
 *                 .type("None")
 *                 .userAssignedIdentities(Map.of("key16", Map.ofEntries(
 *                     Map.entry("clientId", "aaaa"),
 *                     Map.entry("principalId", "aaaaaaaaaaaaaaa")
 *                 )))
 *                 .build())
 *             .localRulestackName("lrs1")
 *             .location("eastus")
 *             .minAppIdVersion("8.5.3")
 *             .panEtag("2bf4a339-294d-4c25-b0b2-ef649e9f5c12")
 *             .panLocation("eastus")
 *             .resourceGroupName("rgopenapi")
 *             .scope("LOCAL")
 *             .securityServices(SecurityServicesArgs.builder()
 *                 .antiSpywareProfile("default")
 *                 .antiVirusProfile("default")
 *                 .dnsSubscription("default")
 *                 .fileBlockingProfile("default")
 *                 .outboundTrustCertificate("default")
 *                 .outboundUnTrustCertificate("default")
 *                 .urlFilteringProfile("default")
 *                 .vulnerabilityProfile("default")
 *                 .build())
 *             .tags(Map.of("tagName", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### LocalRulestacks_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localRulestack = new AzureNative.Cloudngfw.LocalRulestack("localRulestack", new()
 *     {
 *         LocalRulestackName = "lrs1",
 *         Location = "eastus",
 *         ResourceGroupName = "rgopenapi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewLocalRulestack(ctx, "localRulestack", &cloudngfw.LocalRulestackArgs{
 * 			LocalRulestackName: pulumi.String("lrs1"),
 * 			Location:           pulumi.String("eastus"),
 * 			ResourceGroupName:  pulumi.String("rgopenapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestack;
 * import com.pulumi.azurenative.cloudngfw.LocalRulestackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localRulestack = new LocalRulestack("localRulestack", LocalRulestackArgs.builder()
 *             .localRulestackName("lrs1")
 *             .location("eastus")
 *             .resourceGroupName("rgopenapi")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:LocalRulestack armid1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}
 * ```
 * @property associatedSubscriptions subscription scope of global rulestack
 * @property defaultMode Mode for default rules creation
 * @property description rulestack description
 * @property identity The managed service identities assigned to this resource.
 * @property localRulestackName LocalRulestack resource name
 * @property location The geo-location where the resource lives
 * @property minAppIdVersion minimum version
 * @property panEtag PanEtag info
 * @property panLocation Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Rulestack Type
 * @property securityServices Security Profile
 * @property tags Resource tags.
 */
public data class LocalRulestackArgs(
    public val associatedSubscriptions: Output<List<String>>? = null,
    public val defaultMode: Output<Either<String, DefaultMode>>? = null,
    public val description: Output<String>? = null,
    public val identity: Output<AzureResourceManagerManagedIdentityPropertiesArgs>? = null,
    public val localRulestackName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val minAppIdVersion: Output<String>? = null,
    public val panEtag: Output<String>? = null,
    public val panLocation: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<Either<String, ScopeType>>? = null,
    public val securityServices: Output<SecurityServicesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.LocalRulestackArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.LocalRulestackArgs =
        com.pulumi.azurenative.cloudngfw.LocalRulestackArgs.builder()
            .associatedSubscriptions(
                associatedSubscriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .defaultMode(
                defaultMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localRulestackName(localRulestackName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minAppIdVersion(minAppIdVersion?.applyValue({ args0 -> args0 }))
            .panEtag(panEtag?.applyValue({ args0 -> args0 }))
            .panLocation(panLocation?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(
                scope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .securityServices(securityServices?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocalRulestackArgs].
 */
@PulumiTagMarker
public class LocalRulestackArgsBuilder internal constructor() {
    private var associatedSubscriptions: Output<List<String>>? = null

    private var defaultMode: Output<Either<String, DefaultMode>>? = null

    private var description: Output<String>? = null

    private var identity: Output<AzureResourceManagerManagedIdentityPropertiesArgs>? = null

    private var localRulestackName: Output<String>? = null

    private var location: Output<String>? = null

    private var minAppIdVersion: Output<String>? = null

    private var panEtag: Output<String>? = null

    private var panLocation: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<Either<String, ScopeType>>? = null

    private var securityServices: Output<SecurityServicesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value subscription scope of global rulestack
     */
    @JvmName("tdkpyclmcjgpnyfx")
    public suspend fun associatedSubscriptions(`value`: Output<List<String>>) {
        this.associatedSubscriptions = value
    }

    @JvmName("whcmmqkvtnbfrhnf")
    public suspend fun associatedSubscriptions(vararg values: Output<String>) {
        this.associatedSubscriptions = Output.all(values.asList())
    }

    /**
     * @param values subscription scope of global rulestack
     */
    @JvmName("tbagfvxegenoqxsu")
    public suspend fun associatedSubscriptions(values: List<Output<String>>) {
        this.associatedSubscriptions = Output.all(values)
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("foduosjfvrfjtnnj")
    public suspend fun defaultMode(`value`: Output<Either<String, DefaultMode>>) {
        this.defaultMode = value
    }

    /**
     * @param value rulestack description
     */
    @JvmName("qgngedstiytcwjdq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("uttnyqgxqkpwpmhg")
    public suspend fun identity(`value`: Output<AzureResourceManagerManagedIdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("egqunjdqikguaqnd")
    public suspend fun localRulestackName(`value`: Output<String>) {
        this.localRulestackName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("agrmhnedwathqsdd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value minimum version
     */
    @JvmName("vuhqcmpqnhckuaod")
    public suspend fun minAppIdVersion(`value`: Output<String>) {
        this.minAppIdVersion = value
    }

    /**
     * @param value PanEtag info
     */
    @JvmName("eovoipkkgtpsnllf")
    public suspend fun panEtag(`value`: Output<String>) {
        this.panEtag = value
    }

    /**
     * @param value Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
     */
    @JvmName("jrlerotbussgsyiy")
    public suspend fun panLocation(`value`: Output<String>) {
        this.panLocation = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kswwhcoudxromlcw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("kimyrlxsosbeqbdg")
    public suspend fun scope(`value`: Output<Either<String, ScopeType>>) {
        this.scope = value
    }

    /**
     * @param value Security Profile
     */
    @JvmName("foqmseqohgkwwhpn")
    public suspend fun securityServices(`value`: Output<SecurityServicesArgs>) {
        this.securityServices = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ogkkeopmcgvkvprn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value subscription scope of global rulestack
     */
    @JvmName("ixbkwwsxejvoxrwm")
    public suspend fun associatedSubscriptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedSubscriptions = mapped
    }

    /**
     * @param values subscription scope of global rulestack
     */
    @JvmName("qpmymxqgfstibxfy")
    public suspend fun associatedSubscriptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associatedSubscriptions = mapped
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("hnkledqhsytoykwl")
    public suspend fun defaultMode(`value`: Either<String, DefaultMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMode = mapped
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("mrdscfngvrjlvcey")
    public fun defaultMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMode = mapped
    }

    /**
     * @param value Mode for default rules creation
     */
    @JvmName("gdufnwfrgyygdlkk")
    public fun defaultMode(`value`: DefaultMode) {
        val toBeMapped = Either.ofRight<String, DefaultMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMode = mapped
    }

    /**
     * @param value rulestack description
     */
    @JvmName("cggmtjwldbdhdgpt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("wffqhncstwifspph")
    public suspend fun identity(`value`: AzureResourceManagerManagedIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("bgdeklaycmynqhut")
    public suspend fun identity(argument: suspend AzureResourceManagerManagedIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureResourceManagerManagedIdentityPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("tynwjvhuhpeejslk")
    public suspend fun localRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localRulestackName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rekpiuagyjgldunm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value minimum version
     */
    @JvmName("npkrivwwreehqnrr")
    public suspend fun minAppIdVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minAppIdVersion = mapped
    }

    /**
     * @param value PanEtag info
     */
    @JvmName("gtqnchsglwdjtdaf")
    public suspend fun panEtag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.panEtag = mapped
    }

    /**
     * @param value Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
     */
    @JvmName("xiajwumhewkypkuy")
    public suspend fun panLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.panLocation = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iwvijsnoykmprdvs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("twicmawftujatwou")
    public suspend fun scope(`value`: Either<String, ScopeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("hgmntvcmxboapqps")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Rulestack Type
     */
    @JvmName("ruyeolireytvtnep")
    public fun scope(`value`: ScopeType) {
        val toBeMapped = Either.ofRight<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Security Profile
     */
    @JvmName("oxibuthipfnsqwkq")
    public suspend fun securityServices(`value`: SecurityServicesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityServices = mapped
    }

    /**
     * @param argument Security Profile
     */
    @JvmName("eeqdqmusuwhhqvuj")
    public suspend fun securityServices(argument: suspend SecurityServicesArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityServicesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityServices = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eyobrpaojglqpgcu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ynvixoyccyawyrbm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocalRulestackArgs = LocalRulestackArgs(
        associatedSubscriptions = associatedSubscriptions,
        defaultMode = defaultMode,
        description = description,
        identity = identity,
        localRulestackName = localRulestackName,
        location = location,
        minAppIdVersion = minAppIdVersion,
        panEtag = panEtag,
        panLocation = panLocation,
        resourceGroupName = resourceGroupName,
        scope = scope,
        securityServices = securityServices,
        tags = tags,
    )
}
