@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin

import com.pulumi.azurenative.cloudngfw.PreRuleArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.ActionEnum
import com.pulumi.azurenative.cloudngfw.kotlin.enums.BooleanEnum
import com.pulumi.azurenative.cloudngfw.kotlin.enums.DecryptionRuleTypeEnum
import com.pulumi.azurenative.cloudngfw.kotlin.enums.StateEnum
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.CategoryArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.CategoryArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.DestinationAddrArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.DestinationAddrArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.SourceAddrArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.SourceAddrArgsBuilder
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.TagInfoArgs
import com.pulumi.azurenative.cloudngfw.kotlin.inputs.TagInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * PreRulestack rule list
 * Azure REST API version: 2023-09-01.
 * Other available API versions: 2022-08-29, 2022-08-29-preview, 2023-09-01-preview, 2023-10-10-preview, 2024-01-19-preview, 2024-02-07-preview.
 * ## Example Usage
 * ### PreRules_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var preRule = new AzureNative.Cloudngfw.PreRule("preRule", new()
 *     {
 *         ActionType = AzureNative.Cloudngfw.ActionEnum.Allow,
 *         Applications = new[]
 *         {
 *             "app1",
 *         },
 *         AuditComment = "example comment",
 *         Category = new AzureNative.Cloudngfw.Inputs.CategoryArgs
 *         {
 *             Feeds = new[]
 *             {
 *                 "feed",
 *             },
 *             UrlCustom = new[]
 *             {
 *                 "https://microsoft.com",
 *             },
 *         },
 *         DecryptionRuleType = AzureNative.Cloudngfw.DecryptionRuleTypeEnum.SSLOutboundInspection,
 *         Description = "description of pre rule",
 *         Destination = new AzureNative.Cloudngfw.Inputs.DestinationAddrArgs
 *         {
 *             Cidrs = new[]
 *             {
 *                 "1.0.0.1/10",
 *             },
 *             Countries = new[]
 *             {
 *                 "India",
 *             },
 *             Feeds = new[]
 *             {
 *                 "feed",
 *             },
 *             FqdnLists = new[]
 *             {
 *                 "FQDN1",
 *             },
 *             PrefixLists = new[]
 *             {
 *                 "PL1",
 *             },
 *         },
 *         EnableLogging = AzureNative.Cloudngfw.StateEnum.DISABLED,
 *         GlobalRulestackName = "lrs1",
 *         InboundInspectionCertificate = "cert1",
 *         NegateDestination = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         NegateSource = AzureNative.Cloudngfw.BooleanEnum.TRUE,
 *         Priority = "1",
 *         Protocol = "HTTP",
 *         ProtocolPortList = new[]
 *         {
 *             "80",
 *         },
 *         RuleName = "preRule1",
 *         RuleState = AzureNative.Cloudngfw.StateEnum.DISABLED,
 *         Source = new AzureNative.Cloudngfw.Inputs.SourceAddrArgs
 *         {
 *             Cidrs = new[]
 *             {
 *                 "1.0.0.1/10",
 *             },
 *             Countries = new[]
 *             {
 *                 "India",
 *             },
 *             Feeds = new[]
 *             {
 *                 "feed",
 *             },
 *             PrefixLists = new[]
 *             {
 *                 "PL1",
 *             },
 *         },
 *         Tags = new[]
 *         {
 *             new AzureNative.Cloudngfw.Inputs.TagInfoArgs
 *             {
 *                 Key = "keyName",
 *                 Value = "value",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPreRule(ctx, "preRule", &cloudngfw.PreRuleArgs{
 * 			ActionType: pulumi.String(cloudngfw.ActionEnumAllow),
 * 			Applications: pulumi.StringArray{
 * 				pulumi.String("app1"),
 * 			},
 * 			AuditComment: pulumi.String("example comment"),
 * 			Category: &cloudngfw.CategoryArgs{
 * 				Feeds: pulumi.StringArray{
 * 					pulumi.String("feed"),
 * 				},
 * 				UrlCustom: pulumi.StringArray{
 * 					pulumi.String("https://microsoft.com"),
 * 				},
 * 			},
 * 			DecryptionRuleType: pulumi.String(cloudngfw.DecryptionRuleTypeEnumSSLOutboundInspection),
 * 			Description:        pulumi.String("description of pre rule"),
 * 			Destination: &cloudngfw.DestinationAddrArgs{
 * 				Cidrs: pulumi.StringArray{
 * 					pulumi.String("1.0.0.1/10"),
 * 				},
 * 				Countries: pulumi.StringArray{
 * 					pulumi.String("India"),
 * 				},
 * 				Feeds: pulumi.StringArray{
 * 					pulumi.String("feed"),
 * 				},
 * 				FqdnLists: pulumi.StringArray{
 * 					pulumi.String("FQDN1"),
 * 				},
 * 				PrefixLists: pulumi.StringArray{
 * 					pulumi.String("PL1"),
 * 				},
 * 			},
 * 			EnableLogging:                pulumi.String(cloudngfw.StateEnumDISABLED),
 * 			GlobalRulestackName:          pulumi.String("lrs1"),
 * 			InboundInspectionCertificate: pulumi.String("cert1"),
 * 			NegateDestination:            pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			NegateSource:                 pulumi.String(cloudngfw.BooleanEnumTRUE),
 * 			Priority:                     pulumi.String("1"),
 * 			Protocol:                     pulumi.String("HTTP"),
 * 			ProtocolPortList: pulumi.StringArray{
 * 				pulumi.String("80"),
 * 			},
 * 			RuleName:  pulumi.String("preRule1"),
 * 			RuleState: pulumi.String(cloudngfw.StateEnumDISABLED),
 * 			Source: &cloudngfw.SourceAddrArgs{
 * 				Cidrs: pulumi.StringArray{
 * 					pulumi.String("1.0.0.1/10"),
 * 				},
 * 				Countries: pulumi.StringArray{
 * 					pulumi.String("India"),
 * 				},
 * 				Feeds: pulumi.StringArray{
 * 					pulumi.String("feed"),
 * 				},
 * 				PrefixLists: pulumi.StringArray{
 * 					pulumi.String("PL1"),
 * 				},
 * 			},
 * 			Tags: cloudngfw.TagInfoArray{
 * 				&cloudngfw.TagInfoArgs{
 * 					Key:   pulumi.String("keyName"),
 * 					Value: pulumi.String("value"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PreRule;
 * import com.pulumi.azurenative.cloudngfw.PreRuleArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.CategoryArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs;
 * import com.pulumi.azurenative.cloudngfw.inputs.TagInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var preRule = new PreRule("preRule", PreRuleArgs.builder()
 *             .actionType("Allow")
 *             .applications("app1")
 *             .auditComment("example comment")
 *             .category(CategoryArgs.builder()
 *                 .feeds("feed")
 *                 .urlCustom("https://microsoft.com")
 *                 .build())
 *             .decryptionRuleType("SSLOutboundInspection")
 *             .description("description of pre rule")
 *             .destination(DestinationAddrArgs.builder()
 *                 .cidrs("1.0.0.1/10")
 *                 .countries("India")
 *                 .feeds("feed")
 *                 .fqdnLists("FQDN1")
 *                 .prefixLists("PL1")
 *                 .build())
 *             .enableLogging("DISABLED")
 *             .globalRulestackName("lrs1")
 *             .inboundInspectionCertificate("cert1")
 *             .negateDestination("TRUE")
 *             .negateSource("TRUE")
 *             .priority("1")
 *             .protocol("HTTP")
 *             .protocolPortList("80")
 *             .ruleName("preRule1")
 *             .ruleState("DISABLED")
 *             .source(SourceAddrArgs.builder()
 *                 .cidrs("1.0.0.1/10")
 *                 .countries("India")
 *                 .feeds("feed")
 *                 .prefixLists("PL1")
 *                 .build())
 *             .tags(TagInfoArgs.builder()
 *                 .key("keyName")
 *                 .value("value")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### PreRules_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var preRule = new AzureNative.Cloudngfw.PreRule("preRule", new()
 *     {
 *         GlobalRulestackName = "lrs1",
 *         Priority = "1",
 *         RuleName = "preRule1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cloudngfw/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cloudngfw.NewPreRule(ctx, "preRule", &cloudngfw.PreRuleArgs{
 * 			GlobalRulestackName: pulumi.String("lrs1"),
 * 			Priority:            pulumi.String("1"),
 * 			RuleName:            pulumi.String("preRule1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cloudngfw.PreRule;
 * import com.pulumi.azurenative.cloudngfw.PreRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var preRule = new PreRule("preRule", PreRuleArgs.builder()
 *             .globalRulestackName("lrs1")
 *             .priority("1")
 *             .ruleName("preRule1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cloudngfw:PreRule aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa /providers/PaloAltoNetworks.Cloudngfw/globalRulestacks/{globalRulestackName}/preRules/{priority}
 * ```
 * @property actionType rule action
 * @property applications array of rule applications
 * @property auditComment rule comment
 * @property category rule category
 * @property decryptionRuleType enable or disable decryption
 * @property description rule description
 * @property destination destination address
 * @property enableLogging enable or disable logging
 * @property globalRulestackName GlobalRulestack resource name
 * @property inboundInspectionCertificate inbound Inspection Certificate
 * @property negateDestination cidr should not be 'any'
 * @property negateSource cidr should not be 'any'
 * @property priority Pre Rule priority
 * @property protocol any, application-default, TCP:number, UDP:number
 * @property protocolPortList prot port list
 * @property ruleName rule name
 * @property ruleState state of this rule
 * @property source source address
 * @property tags tag for rule
 */
public data class PreRuleArgs(
    public val actionType: Output<Either<String, ActionEnum>>? = null,
    public val applications: Output<List<String>>? = null,
    public val auditComment: Output<String>? = null,
    public val category: Output<CategoryArgs>? = null,
    public val decryptionRuleType: Output<Either<String, DecryptionRuleTypeEnum>>? = null,
    public val description: Output<String>? = null,
    public val destination: Output<DestinationAddrArgs>? = null,
    public val enableLogging: Output<Either<String, StateEnum>>? = null,
    public val globalRulestackName: Output<String>? = null,
    public val inboundInspectionCertificate: Output<String>? = null,
    public val negateDestination: Output<Either<String, BooleanEnum>>? = null,
    public val negateSource: Output<Either<String, BooleanEnum>>? = null,
    public val priority: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val protocolPortList: Output<List<String>>? = null,
    public val ruleName: Output<String>? = null,
    public val ruleState: Output<Either<String, StateEnum>>? = null,
    public val source: Output<SourceAddrArgs>? = null,
    public val tags: Output<List<TagInfoArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.PreRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.PreRuleArgs =
        com.pulumi.azurenative.cloudngfw.PreRuleArgs.builder()
            .actionType(
                actionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .applications(applications?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .auditComment(auditComment?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .decryptionRuleType(
                decryptionRuleType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableLogging(
                enableLogging?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .globalRulestackName(globalRulestackName?.applyValue({ args0 -> args0 }))
            .inboundInspectionCertificate(inboundInspectionCertificate?.applyValue({ args0 -> args0 }))
            .negateDestination(
                negateDestination?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .negateSource(
                negateSource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .protocolPortList(protocolPortList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .ruleState(
                ruleState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PreRuleArgs].
 */
@PulumiTagMarker
public class PreRuleArgsBuilder internal constructor() {
    private var actionType: Output<Either<String, ActionEnum>>? = null

    private var applications: Output<List<String>>? = null

    private var auditComment: Output<String>? = null

    private var category: Output<CategoryArgs>? = null

    private var decryptionRuleType: Output<Either<String, DecryptionRuleTypeEnum>>? = null

    private var description: Output<String>? = null

    private var destination: Output<DestinationAddrArgs>? = null

    private var enableLogging: Output<Either<String, StateEnum>>? = null

    private var globalRulestackName: Output<String>? = null

    private var inboundInspectionCertificate: Output<String>? = null

    private var negateDestination: Output<Either<String, BooleanEnum>>? = null

    private var negateSource: Output<Either<String, BooleanEnum>>? = null

    private var priority: Output<String>? = null

    private var protocol: Output<String>? = null

    private var protocolPortList: Output<List<String>>? = null

    private var ruleName: Output<String>? = null

    private var ruleState: Output<Either<String, StateEnum>>? = null

    private var source: Output<SourceAddrArgs>? = null

    private var tags: Output<List<TagInfoArgs>>? = null

    /**
     * @param value rule action
     */
    @JvmName("ivwwsflbsycmooaj")
    public suspend fun actionType(`value`: Output<Either<String, ActionEnum>>) {
        this.actionType = value
    }

    /**
     * @param value array of rule applications
     */
    @JvmName("xtydnplchgwfbsle")
    public suspend fun applications(`value`: Output<List<String>>) {
        this.applications = value
    }

    @JvmName("sodriqypjnehwgaf")
    public suspend fun applications(vararg values: Output<String>) {
        this.applications = Output.all(values.asList())
    }

    /**
     * @param values array of rule applications
     */
    @JvmName("vryjyvrnbdblhxyf")
    public suspend fun applications(values: List<Output<String>>) {
        this.applications = Output.all(values)
    }

    /**
     * @param value rule comment
     */
    @JvmName("vuefalbitskehpoc")
    public suspend fun auditComment(`value`: Output<String>) {
        this.auditComment = value
    }

    /**
     * @param value rule category
     */
    @JvmName("egepbusfmsmkhwge")
    public suspend fun category(`value`: Output<CategoryArgs>) {
        this.category = value
    }

    /**
     * @param value enable or disable decryption
     */
    @JvmName("lratlpyuelvgiodd")
    public suspend fun decryptionRuleType(`value`: Output<Either<String, DecryptionRuleTypeEnum>>) {
        this.decryptionRuleType = value
    }

    /**
     * @param value rule description
     */
    @JvmName("fbqccgcorxpuvpgw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value destination address
     */
    @JvmName("qjcgvhhovdtgmbmb")
    public suspend fun destination(`value`: Output<DestinationAddrArgs>) {
        this.destination = value
    }

    /**
     * @param value enable or disable logging
     */
    @JvmName("purywhacllrelglk")
    public suspend fun enableLogging(`value`: Output<Either<String, StateEnum>>) {
        this.enableLogging = value
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("qmnkjwsyunmqfssq")
    public suspend fun globalRulestackName(`value`: Output<String>) {
        this.globalRulestackName = value
    }

    /**
     * @param value inbound Inspection Certificate
     */
    @JvmName("rsepatjjoqkrgymq")
    public suspend fun inboundInspectionCertificate(`value`: Output<String>) {
        this.inboundInspectionCertificate = value
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("lvewlspvwhfvompc")
    public suspend fun negateDestination(`value`: Output<Either<String, BooleanEnum>>) {
        this.negateDestination = value
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("cjdsyhgjtoaabvvr")
    public suspend fun negateSource(`value`: Output<Either<String, BooleanEnum>>) {
        this.negateSource = value
    }

    /**
     * @param value Pre Rule priority
     */
    @JvmName("vaahhauhykxqkojp")
    public suspend fun priority(`value`: Output<String>) {
        this.priority = value
    }

    /**
     * @param value any, application-default, TCP:number, UDP:number
     */
    @JvmName("rdhaawxjpylnomvg")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value prot port list
     */
    @JvmName("ultlywuibktbepxf")
    public suspend fun protocolPortList(`value`: Output<List<String>>) {
        this.protocolPortList = value
    }

    @JvmName("cjxtwbxnrhgaoeyg")
    public suspend fun protocolPortList(vararg values: Output<String>) {
        this.protocolPortList = Output.all(values.asList())
    }

    /**
     * @param values prot port list
     */
    @JvmName("vuomtladduqspjtp")
    public suspend fun protocolPortList(values: List<Output<String>>) {
        this.protocolPortList = Output.all(values)
    }

    /**
     * @param value rule name
     */
    @JvmName("urdaflkogvxvpqoe")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value state of this rule
     */
    @JvmName("hqjjixbohrooxobs")
    public suspend fun ruleState(`value`: Output<Either<String, StateEnum>>) {
        this.ruleState = value
    }

    /**
     * @param value source address
     */
    @JvmName("ghikkxbjsollygpa")
    public suspend fun source(`value`: Output<SourceAddrArgs>) {
        this.source = value
    }

    /**
     * @param value tag for rule
     */
    @JvmName("tqfbqwryrkotvkpq")
    public suspend fun tags(`value`: Output<List<TagInfoArgs>>) {
        this.tags = value
    }

    @JvmName("pirspltbstvbwcxt")
    public suspend fun tags(vararg values: Output<TagInfoArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values tag for rule
     */
    @JvmName("hqrwnwmurrffbgtn")
    public suspend fun tags(values: List<Output<TagInfoArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value rule action
     */
    @JvmName("gxsbyjovesjwkmnj")
    public suspend fun actionType(`value`: Either<String, ActionEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value rule action
     */
    @JvmName("sllbatdmydnaqojx")
    public fun actionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value rule action
     */
    @JvmName("wtuubpwrgtwsnnjn")
    public fun actionType(`value`: ActionEnum) {
        val toBeMapped = Either.ofRight<String, ActionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value array of rule applications
     */
    @JvmName("hiwfluioqrxsqeal")
    public suspend fun applications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param values array of rule applications
     */
    @JvmName("dtevqoqwmwxwbbap")
    public suspend fun applications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param value rule comment
     */
    @JvmName("neiamlxhkxcprfmq")
    public suspend fun auditComment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditComment = mapped
    }

    /**
     * @param value rule category
     */
    @JvmName("gkgauakarqkjqlok")
    public suspend fun category(`value`: CategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param argument rule category
     */
    @JvmName("egffrvswngpsviiy")
    public suspend fun category(argument: suspend CategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CategoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.category = mapped
    }

    /**
     * @param value enable or disable decryption
     */
    @JvmName("hxpknfeljknotwxo")
    public suspend fun decryptionRuleType(`value`: Either<String, DecryptionRuleTypeEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decryptionRuleType = mapped
    }

    /**
     * @param value enable or disable decryption
     */
    @JvmName("yykfauvxdkswvjpc")
    public fun decryptionRuleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DecryptionRuleTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decryptionRuleType = mapped
    }

    /**
     * @param value enable or disable decryption
     */
    @JvmName("fjfwbnhdioxfivgx")
    public fun decryptionRuleType(`value`: DecryptionRuleTypeEnum) {
        val toBeMapped = Either.ofRight<String, DecryptionRuleTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decryptionRuleType = mapped
    }

    /**
     * @param value rule description
     */
    @JvmName("bgqllgbggebewwsy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value destination address
     */
    @JvmName("fgwlsehrngigkmkk")
    public suspend fun destination(`value`: DestinationAddrArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument destination address
     */
    @JvmName("ulnofgariaypabep")
    public suspend fun destination(argument: suspend DestinationAddrArgsBuilder.() -> Unit) {
        val toBeMapped = DestinationAddrArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value enable or disable logging
     */
    @JvmName("urswriintuxrrtnw")
    public suspend fun enableLogging(`value`: Either<String, StateEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableLogging = mapped
    }

    /**
     * @param value enable or disable logging
     */
    @JvmName("bbgarfcxvpafgcxu")
    public fun enableLogging(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StateEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableLogging = mapped
    }

    /**
     * @param value enable or disable logging
     */
    @JvmName("fucgecesjsvownmy")
    public fun enableLogging(`value`: StateEnum) {
        val toBeMapped = Either.ofRight<String, StateEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableLogging = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("fjbkapsakmholctg")
    public suspend fun globalRulestackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalRulestackName = mapped
    }

    /**
     * @param value inbound Inspection Certificate
     */
    @JvmName("ltaapbvusjfgjpnu")
    public suspend fun inboundInspectionCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundInspectionCertificate = mapped
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("dbtpbjacrexlyene")
    public suspend fun negateDestination(`value`: Either<String, BooleanEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateDestination = mapped
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("adrsinrjbqawwbge")
    public fun negateDestination(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.negateDestination = mapped
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("wcmtxhkbhtcyolte")
    public fun negateDestination(`value`: BooleanEnum) {
        val toBeMapped = Either.ofRight<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.negateDestination = mapped
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("unngoobyerypdumc")
    public suspend fun negateSource(`value`: Either<String, BooleanEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateSource = mapped
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("bfykyhhatstqkoaq")
    public fun negateSource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.negateSource = mapped
    }

    /**
     * @param value cidr should not be 'any'
     */
    @JvmName("sqjnmpvuiiathabg")
    public fun negateSource(`value`: BooleanEnum) {
        val toBeMapped = Either.ofRight<String, BooleanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.negateSource = mapped
    }

    /**
     * @param value Pre Rule priority
     */
    @JvmName("wkaaanqykhqriypl")
    public suspend fun priority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value any, application-default, TCP:number, UDP:number
     */
    @JvmName("rjntywgbartkcnnc")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value prot port list
     */
    @JvmName("jbmpmhsaaptlnegb")
    public suspend fun protocolPortList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolPortList = mapped
    }

    /**
     * @param values prot port list
     */
    @JvmName("kriqbjbulkwekrxh")
    public suspend fun protocolPortList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolPortList = mapped
    }

    /**
     * @param value rule name
     */
    @JvmName("lgumixriudjufsba")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value state of this rule
     */
    @JvmName("foucjukopdesfstk")
    public suspend fun ruleState(`value`: Either<String, StateEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleState = mapped
    }

    /**
     * @param value state of this rule
     */
    @JvmName("jhrhaesklxipknvp")
    public fun ruleState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StateEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleState = mapped
    }

    /**
     * @param value state of this rule
     */
    @JvmName("rmgibytdavcowvgb")
    public fun ruleState(`value`: StateEnum) {
        val toBeMapped = Either.ofRight<String, StateEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleState = mapped
    }

    /**
     * @param value source address
     */
    @JvmName("qmqygqjgphdxqutf")
    public suspend fun source(`value`: SourceAddrArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument source address
     */
    @JvmName("loqwtemkkguqaqho")
    public suspend fun source(argument: suspend SourceAddrArgsBuilder.() -> Unit) {
        val toBeMapped = SourceAddrArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value tag for rule
     */
    @JvmName("oqdeuilnoxdpuaxs")
    public suspend fun tags(`value`: List<TagInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument tag for rule
     */
    @JvmName("fdbtrnyspmxhgwrs")
    public suspend fun tags(argument: List<suspend TagInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TagInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument tag for rule
     */
    @JvmName("kxtyievgvxaygcyl")
    public suspend fun tags(vararg argument: suspend TagInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TagInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument tag for rule
     */
    @JvmName("hxmfwxdjtdydiwpt")
    public suspend fun tags(argument: suspend TagInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TagInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values tag for rule
     */
    @JvmName("wisdhwtpvaxgkbhy")
    public suspend fun tags(vararg values: TagInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PreRuleArgs = PreRuleArgs(
        actionType = actionType,
        applications = applications,
        auditComment = auditComment,
        category = category,
        decryptionRuleType = decryptionRuleType,
        description = description,
        destination = destination,
        enableLogging = enableLogging,
        globalRulestackName = globalRulestackName,
        inboundInspectionCertificate = inboundInspectionCertificate,
        negateDestination = negateDestination,
        negateSource = negateSource,
        priority = priority,
        protocol = protocol,
        protocolPortList = protocolPortList,
        ruleName = ruleName,
        ruleState = ruleState,
        source = source,
        tags = tags,
    )
}
