@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.ManagedIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The properties of the managed service identities assigned to this resource.
 * @property type The type of managed identity assigned to this resource.
 * @property userAssignedIdentities The identities assigned to this resource by the user.
 */
public data class AzureResourceManagerManagedIdentityPropertiesArgs(
    public val type: Output<Either<String, ManagedIdentityType>>,
    public val userAssignedIdentities: Output<Map<String, AzureResourceManagerUserAssignedIdentityArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs =
        com.pulumi.azurenative.cloudngfw.inputs.AzureResourceManagerManagedIdentityPropertiesArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureResourceManagerManagedIdentityPropertiesArgs].
 */
@PulumiTagMarker
public class AzureResourceManagerManagedIdentityPropertiesArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedIdentityType>>? = null

    private var userAssignedIdentities:
        Output<Map<String, AzureResourceManagerUserAssignedIdentityArgs>>? = null

    /**
     * @param value The type of managed identity assigned to this resource.
     */
    @JvmName("xhtmotihrmygkxpp")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The identities assigned to this resource by the user.
     */
    @JvmName("tydcqwrppebpburj")
    public suspend fun userAssignedIdentities(`value`: Output<Map<String, AzureResourceManagerUserAssignedIdentityArgs>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value The type of managed identity assigned to this resource.
     */
    @JvmName("iroqgbvjrfdwruha")
    public suspend fun type(`value`: Either<String, ManagedIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity assigned to this resource.
     */
    @JvmName("igvcqafbvkckkdpg")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity assigned to this resource.
     */
    @JvmName("mkkhhlskadmqgqlq")
    public fun type(`value`: ManagedIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identities assigned to this resource by the user.
     */
    @JvmName("tsvuxwgpaperkinm")
    public suspend fun userAssignedIdentities(`value`: Map<String, AzureResourceManagerUserAssignedIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The identities assigned to this resource by the user.
     */
    @JvmName("wnjdjkkvrejpdomj")
    public suspend fun userAssignedIdentities(vararg argument: Pair<String, suspend AzureResourceManagerUserAssignedIdentityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AzureResourceManagerUserAssignedIdentityArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The identities assigned to this resource by the user.
     */
    @JvmName("jtihqwekujceoclr")
    public fun userAssignedIdentities(vararg values: Pair<String, AzureResourceManagerUserAssignedIdentityArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): AzureResourceManagerManagedIdentityPropertiesArgs =
        AzureResourceManagerManagedIdentityPropertiesArgs(
            type = type ?: throw PulumiNullFieldException("type"),
            userAssignedIdentities = userAssignedIdentities,
        )
}
