@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.CategoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * URL/EDL to match
 * @property feeds feed list
 * @property urlCustom custom URL
 */
public data class CategoryArgs(
    public val feeds: Output<List<String>>,
    public val urlCustom: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.CategoryArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.CategoryArgs =
        com.pulumi.azurenative.cloudngfw.inputs.CategoryArgs.builder()
            .feeds(feeds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .urlCustom(urlCustom.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CategoryArgs].
 */
@PulumiTagMarker
public class CategoryArgsBuilder internal constructor() {
    private var feeds: Output<List<String>>? = null

    private var urlCustom: Output<List<String>>? = null

    /**
     * @param value feed list
     */
    @JvmName("qmtmsxbcbovdfcxu")
    public suspend fun feeds(`value`: Output<List<String>>) {
        this.feeds = value
    }

    @JvmName("nwgsirxnlhihpcmk")
    public suspend fun feeds(vararg values: Output<String>) {
        this.feeds = Output.all(values.asList())
    }

    /**
     * @param values feed list
     */
    @JvmName("jeefbaumlmlcndhb")
    public suspend fun feeds(values: List<Output<String>>) {
        this.feeds = Output.all(values)
    }

    /**
     * @param value custom URL
     */
    @JvmName("esicceyqkkwaqthw")
    public suspend fun urlCustom(`value`: Output<List<String>>) {
        this.urlCustom = value
    }

    @JvmName("eiqavumtvkxbruhv")
    public suspend fun urlCustom(vararg values: Output<String>) {
        this.urlCustom = Output.all(values.asList())
    }

    /**
     * @param values custom URL
     */
    @JvmName("cttlmnemxfkhlnac")
    public suspend fun urlCustom(values: List<Output<String>>) {
        this.urlCustom = Output.all(values)
    }

    /**
     * @param value feed list
     */
    @JvmName("bisgydtdfcrgjiop")
    public suspend fun feeds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param values feed list
     */
    @JvmName("ceyvatglobkilqyr")
    public suspend fun feeds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param value custom URL
     */
    @JvmName("eshkbbpisteowrgk")
    public suspend fun urlCustom(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlCustom = mapped
    }

    /**
     * @param values custom URL
     */
    @JvmName("vaneigfkpfcyyiqa")
    public suspend fun urlCustom(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlCustom = mapped
    }

    internal fun build(): CategoryArgs = CategoryArgs(
        feeds = feeds ?: throw PulumiNullFieldException("feeds"),
        urlCustom = urlCustom ?: throw PulumiNullFieldException("urlCustom"),
    )
}
