@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * destination address
 * @property cidrs special value 'any'
 * @property countries list of countries
 * @property feeds list of feeds
 * @property fqdnLists fqdn list
 * @property prefixLists prefix list
 */
public data class DestinationAddrArgs(
    public val cidrs: Output<List<String>>? = null,
    public val countries: Output<List<String>>? = null,
    public val feeds: Output<List<String>>? = null,
    public val fqdnLists: Output<List<String>>? = null,
    public val prefixLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs =
        com.pulumi.azurenative.cloudngfw.inputs.DestinationAddrArgs.builder()
            .cidrs(cidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .countries(countries?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .feeds(feeds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .fqdnLists(fqdnLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixLists(prefixLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DestinationAddrArgs].
 */
@PulumiTagMarker
public class DestinationAddrArgsBuilder internal constructor() {
    private var cidrs: Output<List<String>>? = null

    private var countries: Output<List<String>>? = null

    private var feeds: Output<List<String>>? = null

    private var fqdnLists: Output<List<String>>? = null

    private var prefixLists: Output<List<String>>? = null

    /**
     * @param value special value 'any'
     */
    @JvmName("kphigiygsmgsbloe")
    public suspend fun cidrs(`value`: Output<List<String>>) {
        this.cidrs = value
    }

    @JvmName("mmhqwfdgpuorwttl")
    public suspend fun cidrs(vararg values: Output<String>) {
        this.cidrs = Output.all(values.asList())
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("sdnxickurrgdcghq")
    public suspend fun cidrs(values: List<Output<String>>) {
        this.cidrs = Output.all(values)
    }

    /**
     * @param value list of countries
     */
    @JvmName("iyijsowrmqvsjvli")
    public suspend fun countries(`value`: Output<List<String>>) {
        this.countries = value
    }

    @JvmName("rgautrjruyvculgx")
    public suspend fun countries(vararg values: Output<String>) {
        this.countries = Output.all(values.asList())
    }

    /**
     * @param values list of countries
     */
    @JvmName("wpfofeohryhadarr")
    public suspend fun countries(values: List<Output<String>>) {
        this.countries = Output.all(values)
    }

    /**
     * @param value list of feeds
     */
    @JvmName("mskfogefvyhpggvi")
    public suspend fun feeds(`value`: Output<List<String>>) {
        this.feeds = value
    }

    @JvmName("ghutfnxudijqtdwp")
    public suspend fun feeds(vararg values: Output<String>) {
        this.feeds = Output.all(values.asList())
    }

    /**
     * @param values list of feeds
     */
    @JvmName("epspfrsplyditjdp")
    public suspend fun feeds(values: List<Output<String>>) {
        this.feeds = Output.all(values)
    }

    /**
     * @param value fqdn list
     */
    @JvmName("wixetlopsudiaqph")
    public suspend fun fqdnLists(`value`: Output<List<String>>) {
        this.fqdnLists = value
    }

    @JvmName("falyqrkvhcthcqfh")
    public suspend fun fqdnLists(vararg values: Output<String>) {
        this.fqdnLists = Output.all(values.asList())
    }

    /**
     * @param values fqdn list
     */
    @JvmName("uyshtffwurjgvcrs")
    public suspend fun fqdnLists(values: List<Output<String>>) {
        this.fqdnLists = Output.all(values)
    }

    /**
     * @param value prefix list
     */
    @JvmName("fxvsokabuqqsquni")
    public suspend fun prefixLists(`value`: Output<List<String>>) {
        this.prefixLists = value
    }

    @JvmName("uigxvmrdivceqmyj")
    public suspend fun prefixLists(vararg values: Output<String>) {
        this.prefixLists = Output.all(values.asList())
    }

    /**
     * @param values prefix list
     */
    @JvmName("avuomjcrrghorxkq")
    public suspend fun prefixLists(values: List<Output<String>>) {
        this.prefixLists = Output.all(values)
    }

    /**
     * @param value special value 'any'
     */
    @JvmName("virxcdbqgaoqbjho")
    public suspend fun cidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("cwajskcfhytjsbny")
    public suspend fun cidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param value list of countries
     */
    @JvmName("ykkcnhqpelideqlg")
    public suspend fun countries(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param values list of countries
     */
    @JvmName("wmiaobhsqoihuupg")
    public suspend fun countries(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param value list of feeds
     */
    @JvmName("wocqyoftyhmqqokd")
    public suspend fun feeds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param values list of feeds
     */
    @JvmName("toocgrwpykvxiidd")
    public suspend fun feeds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param value fqdn list
     */
    @JvmName("webtcpwpgtiumgim")
    public suspend fun fqdnLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnLists = mapped
    }

    /**
     * @param values fqdn list
     */
    @JvmName("tsofecflwynouehd")
    public suspend fun fqdnLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnLists = mapped
    }

    /**
     * @param value prefix list
     */
    @JvmName("xerpelhinuxsrecd")
    public suspend fun prefixLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    /**
     * @param values prefix list
     */
    @JvmName("tufuqvvmhdhjjysh")
    public suspend fun prefixLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    internal fun build(): DestinationAddrArgs = DestinationAddrArgs(
        cidrs = cidrs,
        countries = countries,
        feeds = feeds,
        fqdnLists = fqdnLists,
        prefixLists = prefixLists,
    )
}
