@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.FrontendSettingArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.ProtocolType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Frontend setting for Firewall
 * @property backendConfiguration Backend configurations
 * @property frontendConfiguration Frontend configurations
 * @property name Settings name
 * @property protocol Protocol Type
 */
public data class FrontendSettingArgs(
    public val backendConfiguration: Output<EndpointConfigurationArgs>,
    public val frontendConfiguration: Output<EndpointConfigurationArgs>,
    public val name: Output<String>,
    public val protocol: Output<Either<String, ProtocolType>>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.FrontendSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.FrontendSettingArgs =
        com.pulumi.azurenative.cloudngfw.inputs.FrontendSettingArgs.builder()
            .backendConfiguration(
                backendConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendConfiguration(
                frontendConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FrontendSettingArgs].
 */
@PulumiTagMarker
public class FrontendSettingArgsBuilder internal constructor() {
    private var backendConfiguration: Output<EndpointConfigurationArgs>? = null

    private var frontendConfiguration: Output<EndpointConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, ProtocolType>>? = null

    /**
     * @param value Backend configurations
     */
    @JvmName("ryufvdufqrrqhuqn")
    public suspend fun backendConfiguration(`value`: Output<EndpointConfigurationArgs>) {
        this.backendConfiguration = value
    }

    /**
     * @param value Frontend configurations
     */
    @JvmName("eaajsyhtsvyhcxsg")
    public suspend fun frontendConfiguration(`value`: Output<EndpointConfigurationArgs>) {
        this.frontendConfiguration = value
    }

    /**
     * @param value Settings name
     */
    @JvmName("qpirmgtnmphbkqho")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Protocol Type
     */
    @JvmName("bfpkvwichgmjjlns")
    public suspend fun protocol(`value`: Output<Either<String, ProtocolType>>) {
        this.protocol = value
    }

    /**
     * @param value Backend configurations
     */
    @JvmName("takbpthohtnjoycl")
    public suspend fun backendConfiguration(`value`: EndpointConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendConfiguration = mapped
    }

    /**
     * @param argument Backend configurations
     */
    @JvmName("ysrneapihbbslojr")
    public suspend fun backendConfiguration(argument: suspend EndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendConfiguration = mapped
    }

    /**
     * @param value Frontend configurations
     */
    @JvmName("nmncputildenxamu")
    public suspend fun frontendConfiguration(`value`: EndpointConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendConfiguration = mapped
    }

    /**
     * @param argument Frontend configurations
     */
    @JvmName("ffxpsieakkehgdha")
    public suspend fun frontendConfiguration(argument: suspend EndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendConfiguration = mapped
    }

    /**
     * @param value Settings name
     */
    @JvmName("fyerkfadudcdpimo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Protocol Type
     */
    @JvmName("wppujnerbulpeuxq")
    public suspend fun protocol(`value`: Either<String, ProtocolType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol Type
     */
    @JvmName("ydnhdrbxtnmjafgn")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol Type
     */
    @JvmName("vwqiaxrjspjxdben")
    public fun protocol(`value`: ProtocolType) {
        val toBeMapped = Either.ofRight<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): FrontendSettingArgs = FrontendSettingArgs(
        backendConfiguration = backendConfiguration ?: throw
            PulumiNullFieldException("backendConfiguration"),
        frontendConfiguration = frontendConfiguration ?: throw
            PulumiNullFieldException("frontendConfiguration"),
        name = name ?: throw PulumiNullFieldException("name"),
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
