@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectGlobalRulestackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 * @property name certificate name
 */
public data class GetCertificateObjectGlobalRulestackPlainArgs(
    public val globalRulestackName: String,
    public val name: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectGlobalRulestackPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectGlobalRulestackPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetCertificateObjectGlobalRulestackPlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificateObjectGlobalRulestackPlainArgs].
 */
@PulumiTagMarker
public class GetCertificateObjectGlobalRulestackPlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    private var name: String? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("roqgxlcyfewyllcq")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value certificate name
     */
    @JvmName("xixpdeldqlydvrut")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetCertificateObjectGlobalRulestackPlainArgs =
        GetCertificateObjectGlobalRulestackPlainArgs(
            globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
