@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetFirewallSupportInfoPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property email email address on behalf of which this API called
 * @property firewallName Firewall resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFirewallSupportInfoPlainArgs(
    public val email: String? = null,
    public val firewallName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetFirewallSupportInfoPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetFirewallSupportInfoPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetFirewallSupportInfoPlainArgs.builder()
            .email(email?.let({ args0 -> args0 }))
            .firewallName(firewallName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallSupportInfoPlainArgs].
 */
@PulumiTagMarker
public class GetFirewallSupportInfoPlainArgsBuilder internal constructor() {
    private var email: String? = null

    private var firewallName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value email address on behalf of which this API called
     */
    @JvmName("mwhtqlfgqbllcags")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.email = mapped
    }

    /**
     * @param value Firewall resource name
     */
    @JvmName("qwyoxcunfreukqbs")
    public suspend fun firewallName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eqervlrabqpycdsu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFirewallSupportInfoPlainArgs = GetFirewallSupportInfoPlainArgs(
        email = email,
        firewallName = firewallName ?: throw PulumiNullFieldException("firewallName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
