@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackChangeLogPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 */
public data class GetGlobalRulestackChangeLogPlainArgs(
    public val globalRulestackName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackChangeLogPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackChangeLogPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetGlobalRulestackChangeLogPlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalRulestackChangeLogPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalRulestackChangeLogPlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("jnrnvcppqjyueybv")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    internal fun build(): GetGlobalRulestackChangeLogPlainArgs = GetGlobalRulestackChangeLogPlainArgs(
        globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
    )
}
