@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetLocalRuleCountersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallName
 * @property localRulestackName LocalRulestack resource name
 * @property priority Local Rule priority
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLocalRuleCountersPlainArgs(
    public val firewallName: String? = null,
    public val localRulestackName: String,
    public val priority: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetLocalRuleCountersPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetLocalRuleCountersPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetLocalRuleCountersPlainArgs.builder()
            .firewallName(firewallName?.let({ args0 -> args0 }))
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .priority(priority.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocalRuleCountersPlainArgs].
 */
@PulumiTagMarker
public class GetLocalRuleCountersPlainArgsBuilder internal constructor() {
    private var firewallName: String? = null

    private var localRulestackName: String? = null

    private var priority: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value
     */
    @JvmName("yvxlonhoiucpghkv")
    public suspend fun firewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.firewallName = mapped
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("dawkwustkgnjbnaw")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("ksfavvvplupvwmli")
    public suspend fun priority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sicjieaflilnrown")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLocalRuleCountersPlainArgs = GetLocalRuleCountersPlainArgs(
        firewallName = firewallName,
        localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
