@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localRulestackName LocalRulestack resource name
 * @property priority Local Rule priority
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLocalRulePlainArgs(
    public val localRulestackName: String,
    public val priority: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulePlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetLocalRulePlainArgs.builder()
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .priority(priority.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocalRulePlainArgs].
 */
@PulumiTagMarker
public class GetLocalRulePlainArgsBuilder internal constructor() {
    private var localRulestackName: String? = null

    private var priority: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("jpoakfmfyliluhmj")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("npyjoylldsjrkgiy")
    public suspend fun priority(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sebcpnufxeenvmyh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLocalRulePlainArgs = GetLocalRulePlainArgs(
        localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
