@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListLocalRulestackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localRulestackName LocalRulestack resource name
 * @property name Local Rule priority
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrefixListLocalRulestackPlainArgs(
    public val localRulestackName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListLocalRulestackPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListLocalRulestackPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.GetPrefixListLocalRulestackPlainArgs.builder()
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrefixListLocalRulestackPlainArgs].
 */
@PulumiTagMarker
public class GetPrefixListLocalRulestackPlainArgsBuilder internal constructor() {
    private var localRulestackName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("hirfmxeeqmjxwwim")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value Local Rule priority
     */
    @JvmName("muihibsgykoebamb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("digkparqugulryam")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrefixListLocalRulestackPlainArgs = GetPrefixListLocalRulestackPlainArgs(
        localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
