@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackAppIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appIdVersion
 * @property appPrefix
 * @property globalRulestackName GlobalRulestack resource name
 * @property skip
 * @property top
 */
public data class ListGlobalRulestackAppIdsPlainArgs(
    public val appIdVersion: String? = null,
    public val appPrefix: String? = null,
    public val globalRulestackName: String,
    public val skip: String? = null,
    public val top: Int? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackAppIdsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackAppIdsPlainArgs = com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackAppIdsPlainArgs.builder()
        .appIdVersion(appIdVersion?.let({ args0 -> args0 }))
        .appPrefix(appPrefix?.let({ args0 -> args0 }))
        .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
        .skip(skip?.let({ args0 -> args0 }))
        .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGlobalRulestackAppIdsPlainArgs].
 */
@PulumiTagMarker
public class ListGlobalRulestackAppIdsPlainArgsBuilder internal constructor() {
    private var appIdVersion: String? = null

    private var appPrefix: String? = null

    private var globalRulestackName: String? = null

    private var skip: String? = null

    private var top: Int? = null

    /**
     * @param value
     */
    @JvmName("takenkojxqygwjoo")
    public suspend fun appIdVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.appIdVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("xeffwyhrqsohjwli")
    public suspend fun appPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.appPrefix = mapped
    }

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("tfcydifpmrhkdhev")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tgjknwotxfsmexut")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value
     */
    @JvmName("pswobbrbbheinovc")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListGlobalRulestackAppIdsPlainArgs = ListGlobalRulestackAppIdsPlainArgs(
        appIdVersion = appIdVersion,
        appPrefix = appPrefix,
        globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
        skip = skip,
        top = top,
    )
}
