@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackFirewallsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 */
public data class ListGlobalRulestackFirewallsPlainArgs(
    public val globalRulestackName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackFirewallsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackFirewallsPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackFirewallsPlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGlobalRulestackFirewallsPlainArgs].
 */
@PulumiTagMarker
public class ListGlobalRulestackFirewallsPlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("ttfcngfnkusmagqx")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    internal fun build(): ListGlobalRulestackFirewallsPlainArgs =
        ListGlobalRulestackFirewallsPlainArgs(
            globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
        )
}
