@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackPredefinedUrlCategoriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 * @property skip
 * @property top
 */
public data class ListGlobalRulestackPredefinedUrlCategoriesPlainArgs(
    public val globalRulestackName: String,
    public val skip: String? = null,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackPredefinedUrlCategoriesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackPredefinedUrlCategoriesPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackPredefinedUrlCategoriesPlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGlobalRulestackPredefinedUrlCategoriesPlainArgs].
 */
@PulumiTagMarker
public class ListGlobalRulestackPredefinedUrlCategoriesPlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    private var skip: String? = null

    private var top: Int? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("rthdjifijbpaojgv")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value
     */
    @JvmName("urhgmlgubyreprqt")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value
     */
    @JvmName("bndqqirnxiknqeft")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListGlobalRulestackPredefinedUrlCategoriesPlainArgs =
        ListGlobalRulestackPredefinedUrlCategoriesPlainArgs(
            globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
            skip = skip,
            top = top,
        )
}
