@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackSecurityServicesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalRulestackName GlobalRulestack resource name
 * @property skip
 * @property top
 * @property type
 */
public data class ListGlobalRulestackSecurityServicesPlainArgs(
    public val globalRulestackName: String,
    public val skip: String? = null,
    public val top: Int? = null,
    public val type: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackSecurityServicesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackSecurityServicesPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.ListGlobalRulestackSecurityServicesPlainArgs.builder()
            .globalRulestackName(globalRulestackName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGlobalRulestackSecurityServicesPlainArgs].
 */
@PulumiTagMarker
public class ListGlobalRulestackSecurityServicesPlainArgsBuilder internal constructor() {
    private var globalRulestackName: String? = null

    private var skip: String? = null

    private var top: Int? = null

    private var type: String? = null

    /**
     * @param value GlobalRulestack resource name
     */
    @JvmName("tvtbsjlpcsubfdkn")
    public suspend fun globalRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalRulestackName = mapped
    }

    /**
     * @param value
     */
    @JvmName("lhayalobwmaxwvln")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value
     */
    @JvmName("mtdhrhvtbwemtllv")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    /**
     * @param value
     */
    @JvmName("cjooeetwehdhejsp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): ListGlobalRulestackSecurityServicesPlainArgs =
        ListGlobalRulestackSecurityServicesPlainArgs(
            globalRulestackName = globalRulestackName ?: throw PulumiNullFieldException("globalRulestackName"),
            skip = skip,
            top = top,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
