@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAppIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appIdVersion
 * @property appPrefix
 * @property localRulestackName LocalRulestack resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skip
 * @property top
 */
public data class ListLocalRulestackAppIdsPlainArgs(
    public val appIdVersion: String? = null,
    public val appPrefix: String? = null,
    public val localRulestackName: String,
    public val resourceGroupName: String,
    public val skip: String? = null,
    public val top: Int? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAppIdsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAppIdsPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackAppIdsPlainArgs.builder()
            .appIdVersion(appIdVersion?.let({ args0 -> args0 }))
            .appPrefix(appPrefix?.let({ args0 -> args0 }))
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListLocalRulestackAppIdsPlainArgs].
 */
@PulumiTagMarker
public class ListLocalRulestackAppIdsPlainArgsBuilder internal constructor() {
    private var appIdVersion: String? = null

    private var appPrefix: String? = null

    private var localRulestackName: String? = null

    private var resourceGroupName: String? = null

    private var skip: String? = null

    private var top: Int? = null

    /**
     * @param value
     */
    @JvmName("ejnlgfelgdsiublg")
    public suspend fun appIdVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.appIdVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("wmkiquoevnuchwtc")
    public suspend fun appPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.appPrefix = mapped
    }

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("fdegvhtrwvpomwtc")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xnfgkmohjxsiijra")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("kovodcqfermufccv")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value
     */
    @JvmName("uhmvrwulcgpsgxoj")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListLocalRulestackAppIdsPlainArgs = ListLocalRulestackAppIdsPlainArgs(
        appIdVersion = appIdVersion,
        appPrefix = appPrefix,
        localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        skip = skip,
        top = top,
    )
}
